/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.model.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.cms.model.security.XssValidatorService;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;

public class AntiSamyXssValidator
implements XssValidatorService {
    private final Log logger = LogFactory.getLog(this.getClass());
    private AntiSamy antiSamy = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AntiSamyXssValidator() {
        InputStream policyFile = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Loading xss policy file");
            }
            policyFile = this.getClass().getResourceAsStream("/properties/antiSamyPolicy.xml");
            Policy policy = Policy.getInstance((InputStream)policyFile);
            this.antiSamy = new AntiSamy(policy);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (policyFile != null) {
                    policyFile.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public List<?> scan(String html) {
        ArrayList errorList = new ArrayList();
        try {
            CleanResults cr;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Unescaping html content");
            }
            html = StringEscapeUtils.unescapeHtml((String)html);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Validaing content for xss");
            }
            if ((cr = this.antiSamy.scan(html)).getNumberOfErrors() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Rejecting content for xss");
                }
                errorList = cr.getErrorMessages();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            errorList.add(e.getMessage());
        }
        return errorList;
    }
}

