/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.model.security;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.cms.model.security.AntiVirusException;
import org.jasig.portlet.cms.model.security.AntiVirusService;

public final class ClamAVAntiVirus
implements AntiVirusService {
    private static final int DEFAULT_PORT = 3310;
    private static final String DEFAULT_IP = "127.0.0.1";
    private final Log logger = LogFactory.getLog(this.getClass());
    private String ip;
    private int port;

    public ClamAVAntiVirus() {
        this.setIp(DEFAULT_IP);
        this.setPort(3310);
    }

    private void closeSocket(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Socket connect() {
        Socket socket = null;
        try {
            socket = new Socket(this.ip, this.port);
        }
        catch (Exception e) {
            socket = null;
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return socket;
    }

    public void scan(File file) throws AntiVirusException {
        String filePath = file.getAbsolutePath();
        if (!file.exists()) {
            throw new AntiVirusException(file, "antivirus.scan.file.not.found");
        }
        if (file.length() <= 0L) {
            throw new AntiVirusException(file, "antivirus.scan.file.empty");
        }
        Socket socket = this.connect();
        if (socket == null) {
            throw new AntiVirusException(file, "antivirus.scan.engine.offline");
        }
        try {
            String results = this.sendSocket(socket, "SCAN " + filePath);
            if (results.indexOf("OK") == -1) {
                String virus = results.substring(results.indexOf(58) + 1);
                if (file.exists()) {
                    file.delete();
                }
                throw new AntiVirusException(file, virus);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new AntiVirusException(file, "");
        }
        finally {
            this.closeSocket(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendSocket(Socket socket, String command) throws Exception {
        String answer = null;
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            writer.println(command);
            writer.flush();
            answer = reader.readLine();
            if (answer != null) {
                answer = answer.trim();
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (writer != null) {
                writer.close();
            }
        }
        return answer;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

