/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlets.FeedbackPortlet.web;

import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlets.FeedbackPortlet.FeedbackQueryParameters;
import org.jasig.portlets.FeedbackPortlet.dao.FeedbackStore;
import org.jasig.portlets.FeedbackPortlet.web.ViewFeedbackForm;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class ViewFeedbackFormController {
    private static Log log = LogFactory.getLog(ViewFeedbackFormController.class);
    public static final long MILLIS_IN_A_DAY = 86400000L;
    private static final long MILLIS_IN_30_DAYS = 2592000000L;
    private static final String DATEPICKER_FORMAT = "dateformat-m-sl-d-sl-Y";
    private FeedbackStore feedbackStore;

    @RequestMapping(method={RequestMethod.POST})
    protected void onSubmitAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="viewFeedbackForm") ViewFeedbackForm form) throws Exception {
        PortletSession session = request.getPortletSession();
        FeedbackQueryParameters queryParameters = (FeedbackQueryParameters)session.getAttribute("feedbackQueryParameters", 1);
        queryParameters.updateParametersWithForm(form);
        session.setAttribute("feedbackQueryParameters", (Object)queryParameters, 1);
    }

    @RequestMapping
    protected ModelAndView showForm(RenderRequest request) throws Exception {
        PortletSession session = request.getPortletSession();
        if (session.getAttribute("feedbackQueryParameters", 1) == null) {
            session.setAttribute("feedbackQueryParameters", (Object)new FeedbackQueryParameters(), 1);
        }
        FeedbackQueryParameters queryParameters = (FeedbackQueryParameters)session.getAttribute("feedbackQueryParameters", 1);
        String start = request.getParameter("start");
        if (start != null && !start.equals("")) {
            int startNum = Integer.parseInt(start);
            if (startNum < 0) {
                startNum = 0;
            }
            session.setAttribute("start", (Object)startNum);
            queryParameters.setPagingStart(startNum);
        }
        List theFeedbackItems = this.feedbackStore.getFeedback(queryParameters);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(queryParameters.putIntoModelMap());
        model.put("totalItems", this.feedbackStore.getFeedbackTotal(queryParameters));
        model.put("stats", this.feedbackStore.getStats());
        model.put("overallstats", this.feedbackStore.getStatsByRole());
        model.put("feedback", theFeedbackItems);
        model.put("datePickerFormat", DATEPICKER_FORMAT);
        request.setAttribute("viewFeedbackForm", (Object)new ViewFeedbackForm());
        model.put("viewFeedbackForm", new ViewFeedbackForm());
        return new ModelAndView("/viewFeedback", model);
    }

    public void setFeedbackStore(FeedbackStore feedbackStore) {
        this.feedbackStore = feedbackStore;
    }
}

