/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlets.FeedbackPortlet.web;

import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlets.FeedbackPortlet.FeedbackItem;
import org.jasig.portlets.FeedbackPortlet.PortletUserPropertiesResolver;
import org.jasig.portlets.FeedbackPortlet.UserProperties;
import org.jasig.portlets.FeedbackPortlet.dao.FeedbackStore;
import org.jasig.portlets.FeedbackPortlet.service.FeedbackSubmissionListener;
import org.jasig.portlets.FeedbackPortlet.web.SubmitFeedbackForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class SubmitFeedbackFormController {
    private static Log log = LogFactory.getLog(SubmitFeedbackFormController.class);
    private FeedbackStore feedbackStore;
    private int feedbackRows = 3;
    private String feedbackWidth = "95%";
    private int feedbackMaxChars = 500;
    private int feedbackPoliteFlag = 150;
    private int feedbackAssertiveFlag = 20;
    @Autowired
    private PortletUserPropertiesResolver userPropertiesResolver;
    @Autowired
    private List<FeedbackSubmissionListener> feedbackSubmissionListeners;

    @Autowired
    public void setFeedbackRows(int feedbackRows) {
        this.feedbackRows = feedbackRows;
    }

    @Autowired
    public void setFeedbackWidth(String feedbackWidth) {
        this.feedbackWidth = feedbackWidth;
    }

    @Autowired
    public void setFeedbackMaxChars(int feedbackMaxChars) {
        this.feedbackMaxChars = feedbackMaxChars;
    }

    @Autowired
    public void setFeedbackPoliteFlag(int feedbackPoliteFlag) {
        this.feedbackPoliteFlag = feedbackPoliteFlag;
    }

    @Autowired
    public void setFeedbackAssertiveFlag(int feedbackAssertiveFlag) {
        this.feedbackAssertiveFlag = feedbackAssertiveFlag;
    }

    @RequestMapping(method={RequestMethod.POST})
    protected void onSubmit(ActionRequest request, ActionResponse response, @ModelAttribute(value="submitFeedbackForm") SubmitFeedbackForm form) {
        FeedbackItem feedback = new FeedbackItem();
        String text = form.getFeedback().trim();
        if (text.length() > this.feedbackMaxChars) {
            text = text.substring(0, this.feedbackMaxChars);
        }
        feedback.setFeedback(text);
        feedback.setUseragent(form.getUseragent());
        feedback.setFeedbacktype(form.getLike());
        feedback.setTabname(form.getTabname());
        if (request.getRemoteUser() != null) {
            UserProperties user = this.userPropertiesResolver.getProperties((PortletRequest)request);
            feedback.setUserrole(user.getUserrole());
            if (form.getAnonymous() == null) {
                feedback.setUserid(request.getRemoteUser());
                feedback.setUsername(user.getUsername());
                feedback.setUseremail(user.getUseremail());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User submitted new feedback item " + feedback.toString()));
        }
        for (FeedbackSubmissionListener listener : this.feedbackSubmissionListeners) {
            listener.performAction(feedback);
        }
        this.feedbackStore.storeFeedback(feedback);
        request.getPortletSession().setAttribute("viewName", (Object)"feedbackSuccess");
    }

    @RequestMapping(value={"VIEW"})
    public ModelAndView getView(RenderRequest request) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String viewName = "submitFeedback";
        if (request.getPortletSession().getAttribute("viewName") != null) {
            viewName = request.getPortletSession().getAttribute("viewName").toString();
            request.getPortletSession().removeAttribute("viewName");
        }
        map.put("feedbackRows", this.feedbackRows);
        map.put("feedbackWidth", this.feedbackWidth);
        map.put("feedbackMaxChars", this.feedbackMaxChars);
        map.put("feedbackPoliteFlag", this.feedbackPoliteFlag);
        map.put("feedbackAssertiveFlag", this.feedbackAssertiveFlag);
        if (request.getParameter("feedbackTabName") != null) {
            map.put("tabName", request.getParameter("feedbackTabName"));
        }
        map.put("submitFeedbackForm", new SubmitFeedbackForm());
        return new ModelAndView(viewName, map);
    }

    @Autowired
    public void setFeedbackStore(FeedbackStore feedbackStore) {
        this.feedbackStore = feedbackStore;
    }

    public void setUserPropertiesResolver(PortletUserPropertiesResolver resolver) {
        this.userPropertiesResolver = resolver;
    }

    public void setFeedbackSubmissionListeners(List<FeedbackSubmissionListener> listeners) {
        this.feedbackSubmissionListeners = listeners;
    }
}

