/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlets.FeedbackPortlet;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletSession;
import org.jasig.portlets.FeedbackPortlet.web.ViewFeedbackForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackQueryParameters {
    private static final Logger log = LoggerFactory.getLogger(FeedbackQueryParameters.class);
    public static final long MILLIS_IN_A_DAY = 86400000L;
    public static final long MILLIS_IN_30_DAYS = 2592000000L;
    public static final String START_DISPLAY_COUNT = "start";
    public static final String ITEMS_DISPLAYED = "itemsDisplayed";
    public static final String USER_ROLE = "userrole";
    public static final String FEEDBACK_TYPE = "feedbacktype";
    public static final String COMMENTS_ONLY_DISPLAYED = "comments";
    public static final String START_DISPLAY_DATE = "startDisplayDate";
    public static final String END_DISPLAY_DATE = "endDisplayDate";
    public static final String DATE_FORMAT = "MM/dd/yyyy";
    private HashMap queryParameters = new HashMap();

    public FeedbackQueryParameters() {
        this(0, 50, "", "", Boolean.valueOf(false), new Date(System.currentTimeMillis() - 2592000000L), new Date(System.currentTimeMillis()));
    }

    public FeedbackQueryParameters(int start, int items, String role, String feedbacktype, Boolean comments, Date startDate, Date endDate) {
        this.queryParameters.put(START_DISPLAY_COUNT, start);
        this.queryParameters.put(ITEMS_DISPLAYED, items);
        this.queryParameters.put(USER_ROLE, role);
        this.queryParameters.put(FEEDBACK_TYPE, feedbacktype);
        this.queryParameters.put(COMMENTS_ONLY_DISPLAYED, comments);
        this.queryParameters.put(START_DISPLAY_DATE, startDate);
        this.queryParameters.put(END_DISPLAY_DATE, endDate);
    }

    public static FeedbackQueryParameters createParametersFromSession(PortletSession session) {
        int startNum = (Integer)session.getAttribute(START_DISPLAY_COUNT);
        int itemNum = (Integer)session.getAttribute("items");
        String feedback = (String)session.getAttribute(FEEDBACK_TYPE);
        String role = (String)session.getAttribute(USER_ROLE);
        Date startDisplayDate = (Date)session.getAttribute(START_DISPLAY_DATE);
        Date endDisplayDate = (Date)session.getAttribute(END_DISPLAY_DATE);
        Boolean comments = (Boolean)session.getAttribute(COMMENTS_ONLY_DISPLAYED);
        FeedbackQueryParameters params = new FeedbackQueryParameters(startNum, itemNum, role, feedback, comments, startDisplayDate, endDisplayDate);
        session.setAttribute("feedbackQueryParameters", (Object)params, 1);
        return params;
    }

    public void updateParametersWithForm(ViewFeedbackForm form) throws Exception {
        Integer items;
        String type;
        Date endDisplayDate;
        Date startDisplayDate;
        String role = form.getUserrole();
        if (role != null) {
            this.queryParameters.put(USER_ROLE, role);
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMAT);
        if (!form.getStartDisplayDate().equals("")) {
            startDisplayDate = dateFormatter.parse(form.getStartDisplayDate());
        } else {
            String startDefaultDate = dateFormatter.format(new Date(System.currentTimeMillis() - 2592000000L));
            startDisplayDate = dateFormatter.parse(startDefaultDate);
        }
        if (startDisplayDate != null) {
            this.queryParameters.put(START_DISPLAY_DATE, startDisplayDate);
        }
        if (!form.getEndDisplayDate().equals("")) {
            endDisplayDate = dateFormatter.parse(form.getEndDisplayDate());
        } else {
            String endDefaultDate = dateFormatter.format(new Date(System.currentTimeMillis()));
            endDisplayDate = dateFormatter.parse(endDefaultDate);
        }
        if (endDisplayDate != null) {
            this.queryParameters.put(END_DISPLAY_DATE, endDisplayDate);
        }
        if ((type = form.getFeedbacktype()) != null) {
            this.queryParameters.put(FEEDBACK_TYPE, type);
        }
        if ((items = Integer.valueOf(form.getItems())) > 0) {
            this.queryParameters.put(ITEMS_DISPLAYED, items);
        }
        this.queryParameters.put(START_DISPLAY_COUNT, 0);
        Boolean comments = form.getComments();
        if (comments != null) {
            this.queryParameters.put(COMMENTS_ONLY_DISPLAYED, comments);
        }
    }

    public Map putIntoModelMap() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        int startNum = this.getInt(START_DISPLAY_COUNT);
        int itemNum = this.getInt(ITEMS_DISPLAYED);
        String feedback = this.getString(FEEDBACK_TYPE);
        String role = this.getString(USER_ROLE);
        Date startDisplayDate = this.getDate(START_DISPLAY_DATE);
        Date endDisplayDate = this.getDate(END_DISPLAY_DATE);
        Boolean comments = this.getBoolean(COMMENTS_ONLY_DISPLAYED);
        model.put(USER_ROLE, role);
        model.put(FEEDBACK_TYPE, feedback);
        model.put(COMMENTS_ONLY_DISPLAYED, comments);
        model.put(START_DISPLAY_COUNT, startNum);
        model.put("items", itemNum);
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMAT);
        if (log.isDebugEnabled()) {
            log.debug("The start display date is:" + dateFormatter.format(startDisplayDate));
            log.debug("The end display date is:" + dateFormatter.format(endDisplayDate));
        }
        model.put(START_DISPLAY_DATE, dateFormatter.format(startDisplayDate));
        model.put(END_DISPLAY_DATE, dateFormatter.format(endDisplayDate));
        return model;
    }

    public int getInt(String parameterName) {
        Integer returnNum = (Integer)this.queryParameters.get(parameterName);
        if (returnNum != null) {
            return returnNum;
        }
        return 0;
    }

    public void setPagingStart(int newStart) {
        this.queryParameters.put(START_DISPLAY_COUNT, new Integer(newStart));
    }

    public Date getDate(String parameterName) {
        return (Date)this.queryParameters.get(parameterName);
    }

    public Date getEndDate(String parameterName) {
        Date theTime = (Date)this.queryParameters.get(parameterName);
        if (theTime != null) {
            return new Date(theTime.getTime() + 86400000L);
        }
        return null;
    }

    public String getString(String parameterName) {
        Object returnedObject = this.queryParameters.get(parameterName);
        if (returnedObject != null) {
            return returnedObject.toString();
        }
        return null;
    }

    public boolean getBoolean(String parameterName) {
        Object returnedObject = this.queryParameters.get(parameterName);
        if (returnedObject != null) {
            return (Boolean)returnedObject;
        }
        return false;
    }

    public Object getObject(String parameterName) {
        return this.queryParameters.get(parameterName);
    }
}

