/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlets.FeedbackPortlet.dao.hibernate;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.jasig.portlets.FeedbackPortlet.FeedbackItem;
import org.jasig.portlets.FeedbackPortlet.FeedbackQueryParameters;
import org.jasig.portlets.FeedbackPortlet.OverallFeedbackStats;
import org.jasig.portlets.FeedbackPortlet.dao.FeedbackStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateFeedbackStore
extends HibernateDaoSupport
implements FeedbackStore {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void storeFeedback(FeedbackItem feedback) {
        try {
            Session session = this.getSession(false);
            if (feedback.getId() == -1L) {
                session.save((Object)feedback);
            }
            session.update((Object)feedback);
            session.flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<FeedbackItem> getFeedback() {
        List results;
        try {
            Session session = this.getSession(false);
            Criteria crit = session.createCriteria(FeedbackItem.class);
            crit.addOrder(Order.desc((String)"submissiontime"));
            results = crit.list();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        return results;
    }

    public List<FeedbackItem> getFeedback(FeedbackQueryParameters params) {
        List results;
        int start = params.getInt("start");
        int items = params.getInt("itemsDisplayed");
        String role = params.getString("userrole");
        String feedbacktype = params.getString("feedbacktype");
        boolean comments = params.getBoolean("comments");
        Date startDate = params.getDate("startDisplayDate");
        Date endDate = params.getEndDate("endDisplayDate");
        try {
            Session session = this.getSession(false);
            Criteria crit = session.createCriteria(FeedbackItem.class);
            crit.addOrder(Order.desc((String)"submissiontime"));
            crit.setFirstResult(start);
            if (role != null && !role.isEmpty()) {
                crit.add((Criterion)Expression.eq((String)"userrole", (Object)role));
            }
            if (feedbacktype != null && !feedbacktype.isEmpty()) {
                crit.add((Criterion)Expression.eq((String)"feedbacktype", (Object)feedbacktype));
            }
            if (comments) {
                crit.add((Criterion)Expression.or((Criterion)Expression.ne((String)"feedback", (Object)""), (Criterion)Expression.ne((String)"feedback", (Object)" ")));
                crit.add(Expression.isNotNull((String)"feedback"));
            }
            crit.add(Expression.between((String)"submissiontime", (Object)startDate, (Object)endDate));
            crit.setMaxResults(items);
            results = crit.list();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        return results;
    }

    public long getFeedbackTotal(FeedbackQueryParameters params) {
        String role = params.getString("userrole");
        String feedbacktype = params.getString("feedbacktype");
        boolean comments = params.getBoolean("comments");
        Date startDate = params.getDate("startDisplayDate");
        Date endDate = params.getEndDate("endDisplayDate");
        try {
            Session session = this.getSession(false);
            String sql = "select count(item.id) from FeedbackItem item";
            if (role != null && !role.isEmpty()) {
                sql = sql.concat(!sql.contains(" where ") ? " where " : " and ");
                sql = sql.concat("userrole = :userrole");
            }
            if (feedbacktype != null && !feedbacktype.isEmpty()) {
                sql = sql.concat(!sql.contains(" where ") ? " where " : " and ");
                sql = sql.concat("feedbacktype = :feedbacktype");
            }
            if (comments) {
                sql = sql.concat(!sql.contains(" where ") ? " where " : " and ");
                sql = sql.concat("LENGTH(feedback) > 0");
            }
            if (startDate != null && endDate != null) {
                sql = sql.concat(!sql.contains(" where ") ? " where " : " and ");
                sql = sql.concat("submissiontime BETWEEN :startDate AND :endDate");
            }
            Query query = session.createQuery(sql);
            if (role != null && !role.isEmpty()) {
                query.setString("userrole", role);
            }
            if (feedbacktype != null && !feedbacktype.isEmpty()) {
                query.setString("feedbacktype", feedbacktype);
            }
            if (startDate != null && endDate != null) {
                query.setDate("startDate", startDate);
                query.setDate("endDate", endDate);
            }
            return (Long)query.uniqueResult();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public OverallFeedbackStats getStats() {
        OverallFeedbackStats stats = new OverallFeedbackStats();
        try {
            Session session = this.getSession(false);
            stats.setUniqueUsers(((Long)session.createQuery("select count(distinct item.userid) from FeedbackItem item").uniqueResult()).longValue());
            for (Object[] row : session.createQuery("select item.feedbacktype, count(item) from FeedbackItem item group by item.feedbacktype").list()) {
                String feedbacktype = (String)row[0];
                Long count = (Long)row[1];
                if (feedbacktype.equals(FeedbackItem.YES)) {
                    stats.setPositiveResponses(count.longValue());
                    continue;
                }
                if (feedbacktype.equals(FeedbackItem.NO)) {
                    stats.setNegativeResponses(count.longValue());
                    continue;
                }
                stats.setUndecidedResponses(count.longValue());
            }
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        return stats;
    }

    public Map<String, OverallFeedbackStats> getStatsByRole() {
        OverallFeedbackStats stats = new OverallFeedbackStats();
        HashMap<String, OverallFeedbackStats> statsMap = new HashMap<String, OverallFeedbackStats>();
        try {
            String userrole;
            Session session = this.getSession(false);
            for (Object[] row : session.createQuery("select item.userrole, count(distinct item.userid) from FeedbackItem item group by item.userrole").list()) {
                userrole = (String)row[0];
                Long count = (Long)row[1];
                stats = new OverallFeedbackStats();
                stats.setUniqueUsers(count.longValue());
                statsMap.put(userrole, stats);
            }
            for (Object[] row : session.createQuery("select item.userrole, item.feedbacktype, count(item) from FeedbackItem item group by item.userrole, item.feedbacktype").list()) {
                userrole = (String)row[0];
                String feedbacktype = (String)row[1];
                Long count = (Long)row[2];
                stats = (OverallFeedbackStats)statsMap.get(userrole);
                if (feedbacktype.equals(FeedbackItem.YES)) {
                    stats.setPositiveResponses(count.longValue());
                    continue;
                }
                if (feedbacktype.equals(FeedbackItem.NO)) {
                    stats.setNegativeResponses(count.longValue());
                    continue;
                }
                stats.setUndecidedResponses(count.longValue());
            }
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        return statsMap;
    }
}

