/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateModeTest
extends AbstractController {
    public StateModeTest() {
        this.setRenderWhenMinimized(true);
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        String requestedWindowState;
        PortletMode actionPortletMode = request.getPortletMode();
        WindowState actionWindowState = request.getWindowState();
        this.logger.info((Object)("Handling ActionRequest with PortletMode='" + actionPortletMode + "' and WindowState='" + actionWindowState + "'"));
        response.setRenderParameter("ACTION_PORTLET_MODE", actionPortletMode.toString());
        response.setRenderParameter("ACTION_WINDOW_STATE", actionWindowState.toString());
        String requestedPortletMode = request.getParameter("REQUESTED_PORTLET_MODE");
        if (requestedPortletMode != null) {
            this.logger.info((Object)("PortletMode '" + requestedPortletMode + "' requested to be set during action."));
            PortletMode portletMode = new PortletMode(requestedPortletMode);
            boolean portletModeAllowed = request.isPortletModeAllowed(portletMode);
            if (portletModeAllowed) {
                try {
                    response.setPortletMode(portletMode);
                }
                catch (PortletException pe) {
                    this.logger.warn((Object)("Failed to set requested PortletMode to '" + portletMode + "' during action."), (Throwable)pe);
                    throw pe;
                }
            } else {
                response.setRenderParameter("REQUESTED_PORTLET_MODE_NOT_ALLOWED", portletMode.toString());
                this.logger.info((Object)("PortletMode '" + portletMode + "' is not allowed."));
            }
        }
        if ((requestedWindowState = request.getParameter("REQUESTED_WINDOW_STATE")) != null) {
            this.logger.info((Object)("WindowState '" + requestedWindowState + "' requested to be set during action."));
            WindowState windowState = new WindowState(requestedWindowState);
            boolean windowStateAllowed = request.isWindowStateAllowed(windowState);
            if (windowStateAllowed) {
                try {
                    response.setWindowState(windowState);
                }
                catch (PortletException pe) {
                    this.logger.warn((Object)("Failed to set requested WindowState to '" + windowState + "' during action."), (Throwable)pe);
                    throw pe;
                }
            } else {
                response.setRenderParameter("REQUESTED_WINDOW_STATE_NOT_ALLOWED", windowState.toString());
                this.logger.info((Object)("WindowState '" + windowState + "' is not allowed."));
            }
        }
    }

    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        PortalContext portalContext = request.getPortalContext();
        List supportedPortletModes = this.toStringList(portalContext.getSupportedPortletModes());
        List supportedWindowStates = this.toStringList(portalContext.getSupportedWindowStates());
        HashMap<String, List> model = new HashMap<String, List>();
        model.put("supportedPortletModes", supportedPortletModes);
        model.put("supportedWindowStates", supportedWindowStates);
        return new ModelAndView("stateModeTest", model);
    }

    protected List<String> toStringList(Enumeration<?> enumeration) {
        LinkedList<String> list = new LinkedList<String>();
        while (enumeration.hasMoreElements()) {
            Object nextElement = enumeration.nextElement();
            list.add(nextElement.toString());
        }
        return list;
    }
}

