/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsUserInRoleTest
extends AbstractController {
    private Map<String, String> roles = null;

    public Map<String, String> getRoles() {
        return this.roles;
    }

    @Required
    public void setRoles(Map<String, String> roles) {
        Validate.notNull(roles);
        this.roles = roles;
    }

    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        HashMap<String, Boolean> roleTests = new HashMap<String, Boolean>();
        HashMap<String, Boolean> roleLinkTests = new HashMap<String, Boolean>();
        for (Map.Entry roleEntry : this.roles.entrySet()) {
            String role = (String)roleEntry.getKey();
            boolean userInRole = request.isUserInRole(role);
            roleTests.put(role, userInRole);
            String roleLink = (String)roleEntry.getValue();
            boolean userInRoleLink = request.isUserInRole(roleLink);
            roleLinkTests.put(roleLink, userInRoleLink);
        }
        HashMap<String, Map> model = new HashMap<String, Map>();
        model.put("roles", this.roles);
        model.put("roleTests", roleTests);
        model.put("roleLinkTests", roleLinkTests);
        return new ModelAndView("userInRoleTest", model);
    }
}

