/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.list.LazyList;
import org.jasig.portlet.test.mvc.tests.PortletPrefrencesTest;
import org.jasig.portlet.test.om.prefs.Preference;
import org.jasig.portlet.test.om.prefs.Preferences;
import org.springframework.validation.BindException;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.PortletRequestUtils;
import org.springframework.web.portlet.mvc.AbstractFormController;

public class PortletPrefrencesTest
extends AbstractFormController {
    private static final PreferenceFactory PREFERENCE_FACTORY = new PreferenceFactory(null);
    private static final StringFactory STRING_FACTORY = new StringFactory(null);

    protected void processFormSubmission(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        Preferences preferences = (Preferences)command;
        List preferencesList = preferences.getPreferences();
        int delPrefIndex = PortletRequestUtils.getIntParameter((PortletRequest)request, (String)"delPrefIndex", (int)-1);
        if (delPrefIndex >= 0) {
            int delValueIndex = PortletRequestUtils.getIntParameter((PortletRequest)request, (String)"delValueIndex", (int)-1);
            if (delValueIndex >= 0) {
                Preference preference = (Preference)preferencesList.get(delPrefIndex);
                List values = preference.getValues();
                values.remove(delValueIndex);
            } else {
                preferencesList.remove(delPrefIndex);
            }
        }
        PortletPreferences portletPreferences = request.getPreferences();
        Enumeration names = portletPreferences.getNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            portletPreferences.reset(name);
        }
        for (Preference preference : preferencesList) {
            String name = preference.getName();
            List values = preference.getValues();
            String[] valuesArray = values != null ? values.toArray(new String[values.size()]) : null;
            portletPreferences.setValues(name, valuesArray);
        }
        portletPreferences.store();
    }

    protected ModelAndView renderFormSubmission(RenderRequest request, RenderResponse response, Object command, BindException errors) throws Exception {
        return super.showNewForm(request, response);
    }

    protected ModelAndView showForm(RenderRequest request, RenderResponse response, BindException errors) throws Exception {
        return super.showForm(request, errors, "portletPreferencesTest");
    }

    protected Object formBackingObject(PortletRequest request) throws Exception {
        boolean formSubmission = this.isFormSubmission(request);
        PortletPreferences portletPreferences = request.getPreferences();
        Map prefMap = portletPreferences.getMap();
        List<Preference> preferences = new ArrayList(prefMap.size() + 1);
        if (formSubmission) {
            preferences = LazyList.decorate(preferences, (Factory)PREFERENCE_FACTORY);
        }
        for (Map.Entry prefEntry : prefMap.entrySet()) {
            Preference preference = new Preference();
            preference.setName((String)prefEntry.getKey());
            String[] values = (String[])prefEntry.getValue();
            List<String> valuesList = new ArrayList<String>(Arrays.asList(values));
            if (formSubmission) {
                valuesList = LazyList.decorate(valuesList, (Factory)STRING_FACTORY);
            }
            preference.setValues(valuesList);
            preferences.add(preference);
        }
        Preferences prefs = new Preferences();
        prefs.setPreferences(preferences);
        return prefs;
    }

    static /* synthetic */ StringFactory access$200() {
        return STRING_FACTORY;
    }
}

