/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.portlet.test.resourceurl;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;

import javax.portlet.ResourceRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

/**
 * Simple {@link Controller} that responds to test resource urls.
 * 
 * @author Nicholas Blair
 * @version $Id: ResourceURLController.java 22042 2010-10-21 18:38:36Z nblair $
 */
@Controller
@RequestMapping("VIEW")
public class ResourceURLController {
	
	@RequestMapping
	protected String displayBasicTestView() {
		return "resourceUrlTest";
	}
	
	@ResourceMapping(value="basicJsonResourceUrl")
	protected String handleBasicJsonResourceUrl(ModelMap model) {
		model.addAttribute("hello", "world");
		model.addAttribute("currentTime", new Date().toString());
		return "jsonView";
	}
	
	@RequestMapping(params="testname=param")
	protected String displayParameterTestView(ModelMap model, 
			@RequestParam(value="renderParameter", required=false, defaultValue="") String renderParam) {
		model.addAttribute("existingRenderParameterValue", renderParam);
		return "resourceParamTest";
	}
	
	@ResourceMapping(value="paramJsonResourceUrl")
	protected String handleParamResourceUrl(ResourceRequest request, ModelMap model) {
		// previous render params
		Map<String, String[]> previousRenderParams = request.getPrivateRenderParameterMap();
		// resource parameter
		Map<String, String[]> resourceParams = request.getPrivateParameterMap();
		
		String [] renderParams = previousRenderParams.get("renderParameter");
		if(renderParams == null) {
			model.addAttribute("renderParameter", "");
		} else {
			model.addAttribute("renderParameter", renderParams[0]);
		}
		
		model.addAttribute("resourceParameter", Arrays.toString(resourceParams.get("resourceParameter")));
		return "jsonView";
	}
}
