/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.event;

import java.io.Serializable;
import java.util.Date;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.util.PortletUtils;

@Controller
@RequestMapping(value={"VIEW"})
public class EventTestController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderMapping(value="NORMAL")
    public String viewEventsTest(@RequestParam(value="simpleEvent", required=false) String simpleEvent, PortletSession portletSession, ModelMap model) {
        Long eventCount;
        this.logger.debug("Rendering Event Test");
        if (simpleEvent != null) {
            model.put((Object)"simpleEvent", (Object)simpleEvent);
        }
        Object object = PortletUtils.getSessionMutex((PortletSession)portletSession);
        synchronized (object) {
            eventCount = (Long)portletSession.getAttribute("EndlessTestEvent");
        }
        if (eventCount != null) {
            model.put((Object)"endlessEvent", (Object)eventCount);
        }
        return "eventTest";
    }

    @ActionMapping(value="simpleEventTest")
    public void simpleEventTest(ActionResponse response) {
        Date now = new Date();
        this.logger.debug("Sending SimpleTestEvent={} from action handler", (Object)now);
        response.setEvent("SimpleTestEvent", (Serializable)now);
    }

    @EventMapping(value="SimpleTestEvent")
    public void simpleEventHandler(EventRequest eventRequest, EventResponse eventResponse) {
        Event event = eventRequest.getEvent();
        this.logger.debug("Handling SimpleTestEvent: {}", (Object)event);
        Date value = (Date)event.getValue();
        this.logger.debug("Setting render parameter simpleEvent={}", (Object)value);
        eventResponse.setRenderParameter("simpleEvent", value.toString());
    }

    @ActionMapping(value="endlessEventTest")
    public void exponentialEventTest(ActionResponse response) {
        this.logger.debug("Sending EndlessTestEvent={} from action handler", (Object)0L);
        response.setEvent("EndlessTestEvent", (Serializable)Long.valueOf(0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventMapping(value="EndlessTestEvent")
    public void exponentialEventTest(EventRequest eventRequest, EventResponse eventResponse) {
        Event event = eventRequest.getEvent();
        this.logger.debug("Handling EndlessTestEvent: " + event);
        Long eventCount = (Long)event.getValue();
        PortletSession portletSession = eventRequest.getPortletSession();
        Object object = PortletUtils.getSessionMutex((PortletSession)portletSession);
        synchronized (object) {
            portletSession.setAttribute("EndlessTestEvent", (Object)eventCount);
        }
        Long newCount = eventCount + 1L;
        this.logger.debug("Sending EndlessTestEvent=" + newCount + " from event handler");
        eventResponse.setEvent("EndlessTestEvent", (Serializable)newCount);
    }
}

