/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.resourceurl;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.portlet.ResourceRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ResourceURLController {
    @RequestMapping
    protected String displayBasicTestView() {
        return "resourceUrlTest";
    }

    @ResourceMapping(value="basicJsonResourceUrl")
    protected String handleBasicJsonResourceUrl(ModelMap model) {
        model.addAttribute("hello", (Object)"world");
        model.addAttribute("currentTime", (Object)new Date().toString());
        return "jsonView";
    }

    @RequestMapping(params={"testname=param"})
    protected String displayParameterTestView(ModelMap model, @RequestParam(value="renderParameter", required=false, defaultValue="") String renderParam) {
        model.addAttribute("existingRenderParameterValue", (Object)renderParam);
        return "resourceParamTest";
    }

    @ResourceMapping(value="paramJsonResourceUrl")
    protected String handleParamResourceUrl(ResourceRequest request, ModelMap model) {
        Map previousRenderParams = request.getPrivateRenderParameterMap();
        Map resourceParams = request.getPrivateParameterMap();
        String[] renderParams = (String[])previousRenderParams.get("renderParameter");
        if (renderParams == null) {
            model.addAttribute("renderParameter", (Object)"");
        } else {
            model.addAttribute("renderParameter", (Object)renderParams[0]);
        }
        model.addAttribute("resourceParameter", (Object)Arrays.toString((Object[])resourceParams.get("resourceParameter")));
        return "jsonView";
    }
}

