/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.cachecontrol.publicscope;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.ProcessAction;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class CacheControlTestPortlet
extends GenericPortlet {
    private MessageService service = new MessageServiceImpl();

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (request.getETag() != null && this.markupIsStillValid()) {
            response.getCacheControl().setExpirationTime(30);
            response.getCacheControl().setUseCachedContent(true);
            return;
        }
        String newEtag = RandomStringUtils.randomAlphabetic((int)12);
        response.getCacheControl().setETag(newEtag);
        response.getCacheControl().setExpirationTime(60);
        request.setAttribute("lastRenderUser", (Object)request.getRemoteUser());
        request.setAttribute("lastRenderTime", (Object)new Date());
        request.setAttribute("messages", this.service.getMessages());
        PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/cacheControlGenericPortletView.jsp");
        rd.include(request, response);
    }

    @ProcessAction(name="addMessage")
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String what = request.getParameter("message");
        if (StringUtils.isNotBlank((String)what)) {
            String who = request.getRemoteUser();
            Message newMessage = new Message(who, what);
            this.service.storeMessage(newMessage);
        }
    }

    protected boolean markupIsStillValid() {
        return !this.service.hasNewMessages();
    }

    private static class MessageServiceImpl
    implements MessageService {
        private LinkedList<Message> messages = new LinkedList();
        private Message lastReadMessage = null;

        private MessageServiceImpl() {
        }

        @Override
        public synchronized void storeMessage(Message message) {
            this.messages.add(message);
        }

        @Override
        public synchronized List<Message> getMessages() {
            this.lastReadMessage = this.messages.peekLast();
            return new ArrayList<Message>(this.messages);
        }

        @Override
        public synchronized boolean hasNewMessages() {
            if (this.lastReadMessage == null) {
                return false;
            }
            Message currentLast = this.messages.peekLast();
            return !this.lastReadMessage.equals(currentLast);
        }
    }

    private static interface MessageService {
        public void storeMessage(Message var1);

        public List<Message> getMessages();

        public boolean hasNewMessages();
    }

    private static class Message {
        private final String who;
        private final String what;
        private final Date when;

        private Message(String who, String what) {
            this.who = who;
            this.what = what;
            this.when = new Date();
        }

        public String toString() {
            return this.who + " said '" + this.what + "' at " + this.when;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.what == null ? 0 : this.what.hashCode());
            result = 31 * result + (this.when == null ? 0 : this.when.hashCode());
            result = 31 * result + (this.who == null ? 0 : this.who.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Message other = (Message)obj;
            if (this.what == null ? other.what != null : !this.what.equals(other.what)) {
                return false;
            }
            if (this.when == null ? other.when != null : !this.when.equals(other.when)) {
                return false;
            }
            return !(this.who == null ? other.who != null : !this.who.equals(other.who));
        }
    }
}

