/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.jasig.portlet.test.mvc.tests.BasePortletTest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller(value="cacheControlTest")
@RequestMapping(value={"VIEW", "EDIT", "HELP", "ABOUT"}, params={"currentTest=cacheControlTest"})
public class CacheControlTestController
extends BasePortletTest {
    @Override
    public String getTestName() {
        return "Cache Control Test";
    }

    @RenderMapping
    public String showExpirationTestForm() {
        return "cacheControlExpirationTest";
    }

    @RenderMapping(params={"testname=validation"})
    public String showValidationTestForm() {
        return "cacheControlValidationTest";
    }

    @ResourceMapping(value="jsonExpirationCachingTest")
    public void writeJsonContentWithExpirationCaching(ResourceRequest request, ResourceResponse response) throws IOException {
        response.getCacheControl().setExpirationTime(120);
        response.setContentType("application/json");
        PrintWriter writer = new PrintWriter(response.getPortletOutputStream());
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd h:mm:ss");
        writer.write("{ \"hello\": \"true\", \"timeRendered\": \"" + sdf.format(now) + "\" }");
        writer.close();
    }

    @ResourceMapping(value="jsonValidationCachingTest")
    public void writeJsonContentWithValidationCaching(ResourceRequest request, ResourceResponse response) throws IOException {
        if (request.getETag() != null) {
            response.getCacheControl().setUseCachedContent(true);
            response.getCacheControl().setExpirationTime(60);
            return;
        }
        response.getCacheControl().setETag(RandomStringUtils.randomAlphanumeric((int)16));
        response.getCacheControl().setExpirationTime(120);
        response.setContentType("application/json");
        PrintWriter writer = new PrintWriter(response.getPortletOutputStream());
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd h:mm:ss");
        writer.write("{ \"hello\": \"true\", \"timeRendered\": \"" + sdf.format(now) + "\" }");
        writer.close();
    }

    @ActionMapping(value="cacheClear")
    public void triggerCacheClear() {
    }

    @ActionMapping
    public void emptyAction() {
    }
}

