/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.RenderRequest;
import javax.servlet.http.Cookie;
import javax.validation.Valid;
import org.apache.commons.lang.RandomStringUtils;
import org.jasig.portlet.test.cookie.CookieBeanWrapper;
import org.jasig.portlet.test.cookie.CreateCookieFormBackingObject;
import org.jasig.portlet.test.mvc.tests.BasePortletTest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller(value="cookieTest")
@RequestMapping(value={"VIEW", "EDIT", "HELP", "ABOUT"}, params={"currentTest=cookieTest"})
@SessionAttributes(value={"command"})
public class CookieTestController
extends BasePortletTest {
    @Override
    public String getTestName() {
        return "Cookie Test";
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator(new Validator(){

            public boolean supports(Class<?> clazz) {
                return CreateCookieFormBackingObject.class.equals(clazz);
            }

            public void validate(Object target, Errors errors) {
                ValidationUtils.rejectIfEmpty((Errors)errors, (String)"name", (String)"name.empty", (String)"name field cannot be empty");
                ValidationUtils.rejectIfEmpty((Errors)errors, (String)"value", (String)"value.empty", (String)"value field cannot be empty");
            }
        });
    }

    @RenderMapping
    protected String displayCookies(ModelMap model, RenderRequest request) {
        ArrayList<CookieBeanWrapper> cookieList = new ArrayList<CookieBeanWrapper>();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieList.add(new CookieBeanWrapper(cookie));
            }
        }
        model.addAttribute("cookieListSize", (Object)cookieList.size());
        model.addAttribute("cookieList", cookieList);
        CreateCookieFormBackingObject command = new CreateCookieFormBackingObject();
        model.addAttribute("command", (Object)command);
        return "cookieTestView";
    }

    @ActionMapping
    public void noopAction() {
    }

    @ActionMapping(value="randomCookieAction")
    protected void createRandomCookie(ActionRequest request, ActionResponse response) {
        String name = RandomStringUtils.randomAlphabetic((int)8);
        String value = RandomStringUtils.randomAlphanumeric((int)8);
        Cookie cookie = new Cookie(name, value);
        cookie.setComment("Random Cookie Test comment");
        cookie.setMaxAge(-1);
        cookie.setSecure(request.isSecure());
        response.addProperty(cookie);
    }

    @ActionMapping(value="formCookieAction")
    protected void createFormCookie(@ModelAttribute @Valid CreateCookieFormBackingObject command, BindingResult errors, ActionRequest request, ActionResponse response) {
        if (errors.hasErrors()) {
            return;
        }
        Cookie cookie = command.toCookie();
        response.addProperty(cookie);
    }

    @ActionMapping(value="editCookieAction")
    protected void editExistingCookie(CreateCookieFormBackingObject command, ActionRequest request, ActionResponse response) {
        if (command == null) {
            return;
        }
        Cookie[] existingCookies = request.getCookies();
        if (existingCookies != null) {
            Cookie cookieToAlter = null;
            for (Cookie existing : existingCookies) {
                if (!existing.getName().equals(command.getName())) continue;
                cookieToAlter = existing;
                break;
            }
            if (cookieToAlter != null) {
                response.addProperty(command.toCookie());
            }
        }
    }
}

