/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.jasig.portlet.test.mvc.tests.BasePortletTest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller(value="dynamicTitleTest")
@RequestMapping(value={"VIEW", "EDIT", "HELP", "ABOUT"}, params={"currentTest=dynamicTitleTest"})
public class DynamicTitleTest
extends BasePortletTest {
    private static final String ACTION_TITLE = "ACTION_TITLE";
    private static final String RENDER_TITLE = "RENDER_TITLE";
    private static final String DATE_FORMAT = "yyyy-MM-dd - HH:mm:ss.SSS";

    @Override
    public String getTestName() {
        return "Dynamic Title Test";
    }

    @ActionMapping
    public void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        String formattedDate = simpleDateFormat.format(new Date());
        response.setRenderParameter(ACTION_TITLE, "Action '" + formattedDate + "'");
    }

    @RenderMapping
    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        String actionTitle = request.getParameter(ACTION_TITLE);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        String formattedDate = simpleDateFormat.format(new Date());
        String renderTitle = "Render '" + formattedDate + "'";
        if (actionTitle != null) {
            response.setTitle(actionTitle);
        } else {
            response.setTitle(renderTitle);
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put(ACTION_TITLE, actionTitle);
        model.put(RENDER_TITLE, renderTitle);
        return new ModelAndView("dynamicTitleTest", model);
    }
}

