/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.portlet.filter;

import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.PortletFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.portlet.context.PortletContextAware;
import org.springframework.web.portlet.context.PortletContextResourceLoader;

public abstract class GenericPortletFilterBean
implements PortletFilter,
BeanNameAware,
PortletContextAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Set<String> requiredProperties = new HashSet<String>();
    private FilterConfig filterConfig;
    private String beanName;
    private PortletContext portletContext;

    public final void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public final void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.initFilterBean();
    }

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public void init(FilterConfig filterConfig) throws PortletException {
        Assert.notNull((Object)filterConfig, (String)"FilterConfig must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Initializing filter '" + filterConfig.getFilterName() + "'"));
        }
        this.filterConfig = filterConfig;
        try {
            FilterConfigPropertyValues pvs = new FilterConfigPropertyValues(filterConfig, this.requiredProperties);
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)this);
            PortletContextResourceLoader resourceLoader = new PortletContextResourceLoader(filterConfig.getPortletContext());
            bw.registerCustomEditor(Resource.class, (PropertyEditor)new ResourceEditor((ResourceLoader)resourceLoader));
            this.initBeanWrapper(bw);
            bw.setPropertyValues((PropertyValues)pvs, true);
        }
        catch (BeansException ex) {
            String msg = "Failed to set bean properties on filter '" + filterConfig.getFilterName() + "': " + ex.getMessage();
            this.logger.error((Object)msg, (Throwable)ex);
            throw new PortletException(msg, (Throwable)ex);
        }
        this.initFilterBean();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Filter '" + filterConfig.getFilterName() + "' configured successfully"));
        }
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
    }

    public final FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected final String getFilterName() {
        return this.filterConfig != null ? this.filterConfig.getFilterName() : this.beanName;
    }

    protected final PortletContext getPortletContext() {
        return this.filterConfig != null ? this.filterConfig.getPortletContext() : this.portletContext;
    }

    protected void initFilterBean() throws PortletException {
    }

    public void destroy() {
    }

    private static class FilterConfigPropertyValues
    extends MutablePropertyValues {
        public FilterConfigPropertyValues(FilterConfig config, Set<String> requiredProperties) throws PortletException {
            HashSet<String> missingProps = requiredProperties != null && !requiredProperties.isEmpty() ? new HashSet<String>(requiredProperties) : null;
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                String value = config.getInitParameter(property);
                this.addPropertyValue(new PropertyValue(property, (Object)value));
                if (missingProps == null) continue;
                missingProps.remove(property);
            }
            if (missingProps != null && missingProps.size() > 0) {
                throw new PortletException("Initialization from FilterConfig for filter '" + config.getFilterName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, (String)", "));
            }
        }
    }
}

