/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.cachecontrol.publicscope;

import java.io.IOException;
import java.util.Date;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.ProcessAction;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.test.cachecontrol.publicscope.CacheControlTestPortlet;

public class CacheControlTestPortlet
extends GenericPortlet {
    private MessageService service = new MessageServiceImpl(null);

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (request.getETag() != null && this.markupIsStillValid()) {
            response.getCacheControl().setExpirationTime(30);
            response.getCacheControl().setUseCachedContent(true);
            return;
        }
        String newEtag = RandomStringUtils.randomAlphabetic((int)12);
        response.getCacheControl().setETag(newEtag);
        response.getCacheControl().setExpirationTime(60);
        request.setAttribute("lastRenderUser", (Object)request.getRemoteUser());
        request.setAttribute("lastRenderTime", (Object)new Date());
        request.setAttribute("messages", (Object)this.service.getMessages());
        PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/cacheControlGenericPortletView.jsp");
        rd.include(request, response);
    }

    @ProcessAction(name="addMessage")
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String what = request.getParameter("message");
        if (StringUtils.isNotBlank((String)what)) {
            String who = request.getRemoteUser();
            Message newMessage = new Message(who, what, null);
            this.service.storeMessage(newMessage);
        }
    }

    protected boolean markupIsStillValid() {
        return !this.service.hasNewMessages();
    }
}

