/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;
import org.springframework.web.portlet.mvc.Controller;

public class TestDelegatingSelectorController
extends AbstractController {
    public static final String CURRENT_TEST_ATTR = TestDelegatingSelectorController.class.getName() + ".CURRENT_TEST";
    public static final String TEST_CONTROLLER_NAMES_ATTR = TestDelegatingSelectorController.class.getName() + ".TEST_CONTROLLER_NAMES";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SortedMap<String, Controller> testControllers;

    public TestDelegatingSelectorController() {
        this.setRenderWhenMinimized(true);
    }

    public Map<String, Controller> getTestControllers() {
        return this.testControllers;
    }

    @Required
    public void setTestControllers(Map<String, Controller> testControllers) {
        Validate.notNull(testControllers);
        this.testControllers = testControllers instanceof SortedMap ? (SortedMap)testControllers : new TreeMap<String, Controller>(testControllers);
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        String currentTestName = this.getCurrentTestName((PortletRequest)request);
        this.logger.debug("handleActionRequestInternal for test '{}' with mode: {} and state: {}", new Object[]{currentTestName, request.getPortletMode(), request.getWindowState()});
        String nextTestName = request.getParameter(CURRENT_TEST_ATTR);
        if (nextTestName != null) {
            Controller nextTest = (Controller)this.testControllers.get(nextTestName);
            if (nextTest != null) {
                PortletSession portletSession = request.getPortletSession();
                this.logger.info("Changing to test '{}' from test '{}'", (Object)nextTestName, (Object)currentTestName);
                portletSession.setAttribute(CURRENT_TEST_ATTR, (Object)nextTestName);
            } else {
                this.logger.warn("No test Controller named '{}'", (Object)nextTestName);
            }
        } else {
            this.logger.info("Delegating handleActionRequest to test Controller named '{}'", (Object)currentTestName);
            Controller currentTest = (Controller)this.testControllers.get(currentTestName);
            try {
                currentTest.handleActionRequest(request, response);
            }
            catch (Exception e) {
                this.logger.error("Test '{}' threw an exception during handleActionRequest", (Object)currentTestName, (Object)e);
                throw e;
            }
        }
    }

    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        ModelAndView delegateModelAndView;
        String currentTestName = this.getCurrentTestName((PortletRequest)request);
        request.setAttribute(CURRENT_TEST_ATTR, (Object)currentTestName);
        this.logger.debug("handleRenderRequestInternal for test '{}' with mode: {} and state: {}", new Object[]{currentTestName, request.getPortletMode(), request.getWindowState()});
        if (currentTestName != null) {
            response.setTitle(currentTestName);
        }
        Controller currentTest = (Controller)this.testControllers.get(currentTestName);
        try {
            delegateModelAndView = currentTest.handleRenderRequest(request, response);
        }
        catch (Exception e) {
            this.logger.error("Test '{}' threw an exception during handleRenderRequest", (Object)currentTestName, (Object)e);
            throw e;
        }
        if (delegateModelAndView == null) {
            delegateModelAndView = new ModelAndView("testSelectorHeader");
        }
        Map model = delegateModelAndView.getModel();
        model.put(TEST_CONTROLLER_NAMES_ATTR, this.testControllers.keySet());
        return delegateModelAndView;
    }

    protected String getCurrentTestName(PortletRequest request) {
        PortletSession portletSession = request.getPortletSession();
        String currentTestName = (String)portletSession.getAttribute(CURRENT_TEST_ATTR);
        if (currentTestName == null) {
            currentTestName = (String)this.testControllers.firstKey();
        }
        return currentTestName;
    }
}

