/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.jasig.portlet.test.mvc.tests.BasePortletTest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller(value="cacheControlTest")
@RequestMapping(value={"VIEW", "EDIT", "HELP", "ABOUT"}, params={"currentTest=cacheControlTest"})
public class CacheControlTestController
extends BasePortletTest
implements PortletContextAware {
    private PortletContext portletContext;

    @Override
    public String getTestName() {
        return "Cache Control Test";
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    @RenderMapping
    public String showExpirationTestForm() {
        return "cacheControlExpirationTest";
    }

    @RenderMapping(params={"testname=validation"})
    public String showValidationTestForm() {
        return "cacheControlValidationTest";
    }

    @RenderMapping(params={"testname=servletForward"})
    public String showServletForwardTestForm() {
        return "cacheServletForwardTest";
    }

    @ResourceMapping(value="jsonExpirationCachingTest")
    public void writeJsonContentWithExpirationCaching(ResourceRequest request, ResourceResponse response) throws IOException {
        response.getCacheControl().setExpirationTime(120);
        response.setContentType("application/json");
        PrintWriter writer = new PrintWriter(response.getPortletOutputStream());
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd h:mm:ss");
        writer.write("{ \"hello\": \"true\", \"timeRendered\": \"" + sdf.format(now) + "\" }");
        writer.close();
    }

    @ResourceMapping(value="jsonValidationCachingTest")
    public void writeJsonContentWithValidationCaching(ResourceRequest request, ResourceResponse response) throws IOException {
        if (request.getETag() != null) {
            response.getCacheControl().setUseCachedContent(true);
            response.getCacheControl().setExpirationTime(60);
            return;
        }
        response.getCacheControl().setETag(RandomStringUtils.randomAlphanumeric((int)16));
        response.getCacheControl().setExpirationTime(120);
        response.setContentType("application/json");
        PrintWriter writer = new PrintWriter(response.getPortletOutputStream());
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd h:mm:ss");
        writer.write("{ \"hello\": \"true\", \"timeRendered\": \"" + sdf.format(now) + "\" }");
        writer.close();
    }

    @ResourceMapping(value="servletForwardingTest")
    public void writeServletForwardingTest(ResourceRequest request, ResourceResponse response) throws IOException, PortletException {
        response.getCacheControl().setETag(RandomStringUtils.randomAlphanumeric((int)16));
        response.getCacheControl().setExpirationTime(30);
        PortletRequestDispatcher servletDispatcher = this.portletContext.getRequestDispatcher("/SimpleServlet");
        servletDispatcher.forward((PortletRequest)request, (PortletResponse)response);
    }

    @ActionMapping(value="cacheClear")
    public void triggerCacheClear() {
    }

    @ActionMapping
    public void emptyAction() {
    }
}

