/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.portlet.test.mvc.tests.BasePortletTest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller(value="userInRoleTest")
@RequestMapping(value={"VIEW", "EDIT", "HELP", "ABOUT"}, params={"currentTest=userInRoleTest"})
public class IsUserInRoleTest
extends BasePortletTest {
    private Map<String, String> roles = null;

    @Override
    public String getTestName() {
        return "User Roles Test";
    }

    @Resource(name="portletRoles")
    public void setRoles(Map<String, String> roles) {
        Validate.notNull(roles);
        this.roles = roles;
    }

    @RenderMapping
    public ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        HashMap<String, Boolean> roleTests = new HashMap<String, Boolean>();
        HashMap<String, Boolean> roleLinkTests = new HashMap<String, Boolean>();
        for (Map.Entry<String, String> roleEntry : this.roles.entrySet()) {
            String role = roleEntry.getKey();
            boolean userInRole = request.isUserInRole(role);
            roleTests.put(role, userInRole);
            String roleLink = roleEntry.getValue();
            if (StringUtils.isEmpty((String)roleLink)) continue;
            boolean userInRoleLink = request.isUserInRole(roleLink);
            roleLinkTests.put(roleLink, userInRoleLink);
        }
        HashMap<String, Map<String, Object>> model = new HashMap<String, Map<String, Object>>();
        model.put("roles", this.roles);
        model.put("roleTests", roleTests);
        model.put("roleLinkTests", roleLinkTests);
        return new ModelAndView("userInRoleTest", model);
    }

    @ActionMapping
    public void noopAction() {
    }
}

