/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.web;

import com.google.common.base.Function;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.portlet.ParameterAddingActionRequestWrapper;
import org.springframework.portlet.ParameterAddingEventRequestWrapper;
import org.springframework.portlet.ParameterAddingPortletRequestWrapper;
import org.springframework.portlet.ParameterAddingRenderRequestWrapper;
import org.springframework.portlet.ParameterAddingResourceRequestWrapper;
import org.springframework.stereotype.Component;

@Component(value="testSelectingFilter")
public class TestNameParameterFilter
implements ActionFilter,
EventFilter,
RenderFilter,
ResourceFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String currentTestAttributeName = "currentTest";
    private String currentTestParameterName = "currentTest";

    public void setCurrentTestAttributeName(String currentTestAttributeName) {
        this.currentTestAttributeName = currentTestAttributeName;
    }

    public void setCurrentTestParameterName(String currentTestParameterName) {
        this.currentTestParameterName = currentTestParameterName;
    }

    public void init(FilterConfig filterConfig) throws PortletException {
    }

    public void destroy() {
    }

    public void doFilter(ResourceRequest request, ResourceResponse response, FilterChain chain) throws IOException, PortletException {
        request = this.doFilterInternal(request, new Function<ResourceRequest, ParameterAddingResourceRequestWrapper>(){

            public ParameterAddingResourceRequestWrapper apply(ResourceRequest input) {
                return new ParameterAddingResourceRequestWrapper(input);
            }
        });
        chain.doFilter(request, response);
    }

    public void doFilter(RenderRequest request, RenderResponse response, FilterChain chain) throws IOException, PortletException {
        request = this.doFilterInternal(request, new Function<RenderRequest, ParameterAddingRenderRequestWrapper>(){

            public ParameterAddingRenderRequestWrapper apply(RenderRequest input) {
                return new ParameterAddingRenderRequestWrapper(input);
            }
        });
        chain.doFilter(request, response);
    }

    public void doFilter(EventRequest request, EventResponse response, FilterChain chain) throws IOException, PortletException {
        request = this.doFilterInternal(request, new Function<EventRequest, ParameterAddingEventRequestWrapper>(){

            public ParameterAddingEventRequestWrapper apply(EventRequest input) {
                return new ParameterAddingEventRequestWrapper(input);
            }
        });
        chain.doFilter(request, response);
    }

    public void doFilter(ActionRequest request, ActionResponse response, FilterChain chain) throws IOException, PortletException {
        request = this.doFilterInternal(request, new Function<ActionRequest, ParameterAddingActionRequestWrapper>(){

            public ParameterAddingActionRequestWrapper apply(ActionRequest input) {
                return new ParameterAddingActionRequestWrapper(input);
            }
        });
        chain.doFilter(request, response);
    }

    protected <R extends PortletRequest, W extends ParameterAddingPortletRequestWrapper> R doFilterInternal(R request, Function<R, W> createWrapper) {
        PortletSession portletSession = request.getPortletSession();
        String currentTest = request.getParameter(this.currentTestParameterName);
        if (currentTest != null) {
            this.logger.debug("Found test {} as request parameter {}, storing in session under {}", new Object[]{currentTest, this.currentTestParameterName, this.currentTestAttributeName});
            portletSession.setAttribute(this.currentTestAttributeName, (Object)currentTest);
        } else {
            currentTest = (String)portletSession.getAttribute(this.currentTestParameterName);
            if (currentTest != null) {
                this.logger.debug("Found test {} as session attribute {}, adding to request as private attribute {}", new Object[]{currentTest, this.currentTestAttributeName, this.currentTestParameterName});
                ParameterAddingPortletRequestWrapper requestWrapper = (ParameterAddingPortletRequestWrapper)((Object)createWrapper.apply(request));
                requestWrapper.putPrivateParameters(this.currentTestParameterName, new String[]{currentTest});
                request = requestWrapper;
            }
        }
        return request;
    }
}

