/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.controller;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.adapter.INewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;
import org.jasig.web.portlet.mvc.AbstractAjaxController;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxNewsController
extends AbstractAjaxController {
    private static Log log = LogFactory.getLog(AjaxNewsController.class);
    private NewsStore newsStore;
    private NewsSetResolvingService setCreationService;

    protected Map<Object, Object> handleAjaxRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        JSONObject json;
        block11: {
            log.debug((Object)"handleAjaxRequestInternal (AjaxNewsController)");
            json = new JSONObject();
            Long setId = Long.parseLong(request.getPreferences().getValue("newsSetId", "-1"));
            NewsSet set = this.setCreationService.getNewsSet(setId, request);
            Set feeds = set.getNewsConfigurations();
            JSONArray jsonFeeds = new JSONArray();
            for (NewsConfiguration feed : feeds) {
                JSONObject jsonFeed = new JSONObject();
                jsonFeed.put((Object)"id", (Object)feed.getId());
                jsonFeed.put((Object)"name", (Object)feed.getNewsDefinition().getName());
                jsonFeeds.add((Object)jsonFeed);
            }
            json.put((Object)"feeds", (Object)jsonFeeds);
            PortletPreferences prefs = request.getPreferences();
            String activeateNews = request.getParameter("activeateNews");
            if (activeateNews != null) {
                prefs.setValue("activeFeed", activeateNews);
                prefs.store();
            }
            int maxStories = Integer.parseInt(prefs.getValue("maxStories", "10"));
            SyndFeed feed = null;
            ApplicationContext ctx = this.getApplicationContext();
            ArrayList errors = new ArrayList();
            String activeFeed = request.getPreferences().getValue("activeFeed", null);
            if (activeFeed == null && jsonFeeds.size() > 0) {
                activeFeed = ((JSONObject)jsonFeeds.get(0)).getString("id");
                prefs.setValue("activeFeed", activeateNews);
                prefs.store();
            }
            if (activeFeed != null) {
                NewsConfiguration feedConfig = this.newsStore.getNewsConfiguration(Long.valueOf(activeFeed));
                json.put((Object)"activeFeed", (Object)feedConfig.getId());
                log.debug((Object)("On render Active feed is " + feedConfig.getId()));
                try {
                    INewsAdapter adapter = (INewsAdapter)ctx.getBean(feedConfig.getNewsDefinition().getClassName());
                    feed = adapter.getSyndFeed(feedConfig, (PortletRequest)request);
                    log.debug((Object)"Got feed from adapter");
                    if (feed.getEntries().isEmpty()) {
                        json.put((Object)"message", (Object)"<p>No news.</p>");
                        break block11;
                    }
                    JSONObject jsonFeed = new JSONObject();
                    jsonFeed.put((Object)"link", (Object)feed.getLink());
                    jsonFeed.put((Object)"title", (Object)feed.getTitle());
                    jsonFeed.put((Object)"author", (Object)feed.getAuthor());
                    jsonFeed.put((Object)"copyright", (Object)feed.getCopyright());
                    JSONArray jsonEntries = new JSONArray();
                    ListIterator i = feed.getEntries().listIterator();
                    while (i.hasNext() && i.nextIndex() < maxStories) {
                        SyndEntry entry = (SyndEntry)i.next();
                        JSONObject jsonEntry = new JSONObject();
                        jsonEntry.put((Object)"link", (Object)entry.getLink());
                        jsonEntry.put((Object)"title", (Object)entry.getTitle());
                        jsonEntry.put((Object)"description", (Object)entry.getDescription().getValue());
                        jsonEntries.add((Object)jsonEntry);
                    }
                    jsonFeed.put((Object)"entries", (Object)jsonEntries);
                    json.put((Object)"feed", (Object)jsonFeed);
                }
                catch (NoSuchBeanDefinitionException ex) {
                    log.error((Object)("News class instance could not be found: " + ex.getMessage()));
                    json.put((Object)"message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
                }
                catch (NewsException ex) {
                    log.warn((Object)ex);
                    json.put((Object)"message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    json.put((Object)"message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
                }
            } else {
                json.put((Object)"message", (Object)"Select the news you wish to read.");
            }
        }
        log.debug((Object)"forwarding to /ajaxFeedList");
        HashMap<Object, Object> model = new HashMap<Object, Object>();
        model.put("json", json);
        log.debug((Object)json);
        return model;
    }

    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    public void setSetCreationService(NewsSetResolvingService setCreationService) {
        this.setCreationService = setCreationService;
    }
}

