/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.service;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;

public class SharedNewsSetServiceImpl
implements NewsSetResolvingService {
    private static Log log = LogFactory.getLog(SharedNewsSetServiceImpl.class);
    private NewsStore newsStore;

    private NewsSet createNewsSet(ActionRequest request) {
        NewsSet set = new NewsSet();
        set.setUserId(request.getRemoteUser());
        this.newsStore.storeNewsSet(set);
        return set;
    }

    public NewsSet getNewsSet(Long id, ActionRequest request) {
        NewsSet set = null;
        PortletSession session = request.getPortletSession();
        if (id < 0L) {
            List sets = this.newsStore.getNewsSetsForUser(request.getRemoteUser());
            if (!sets.isEmpty()) {
                set = (NewsSet)sets.get(0);
                log.debug((Object)("Found existing set (" + set.getId() + ") for user, returning this for shared use."));
            } else {
                log.debug((Object)"No existing set found, creating and saving new set.");
                set = this.createNewsSet(request);
            }
            PortletPreferences preferences = request.getPreferences();
            try {
                preferences.setValue("newsSetId", String.valueOf(set.getId()));
                preferences.store();
            }
            catch (ReadOnlyException e) {
                e.printStackTrace();
            }
            catch (ValidatorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            log.debug((Object)("Retrieving news set " + id));
            set = this.newsStore.getNewsSet(id);
        }
        if (session.getAttribute("setId") == null) {
            Set roles = (Set)session.getAttribute("userRoles", 2);
            this.newsStore.initNews(set, roles);
            this.newsStore.storeNewsSet(set);
            session.setAttribute("setId", (Object)set.getId(), 2);
        }
        return set;
    }

    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }
}

