/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.dao;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsDefinition;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.PredefinedNewsConfiguration;
import org.jasig.portlet.newsreader.PredefinedNewsDefinition;
import org.jasig.portlet.newsreader.UserDefinedNewsConfiguration;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateNewsStore
extends HibernateDaoSupport
implements NewsStore {
    private static Log log = LogFactory.getLog(HibernateNewsStore.class);

    @Override
    public void storeNewsDefinition(NewsDefinition listing) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)listing);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void storeNewsConfiguration(NewsConfiguration configuration) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)configuration);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public List<NewsConfiguration> getNewsConfigurations(String subscribeId) {
        try {
            log.debug((Object)("fetching news configurations for " + subscribeId));
            return this.getHibernateTemplate().find("from NewsConfiguration config where subscribeId = ? and displayed = true order by newsDefinition.name", (Object)subscribeId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public List<UserDefinedNewsConfiguration> getUserDefinedNewsConfigurations(Long setId, boolean visibleOnly) {
        try {
            String query = "from NewsConfiguration config where config.newsSet.id = ? and config.class = UserDefinedNewsConfiguration order by newsDefinition.name";
            if (visibleOnly) {
                query = query.concat(" and visibleOnly = true");
            }
            return this.getHibernateTemplate().find(query, (Object)setId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public List<PredefinedNewsConfiguration> getPredefinedNewsConfigurations(Long setId, boolean visibleOnly) {
        try {
            String query = "from NewsConfiguration config where config.newsSet.id = ? and config.class = PredefinedNewsConfiguration order by newsDefinition.name";
            if (visibleOnly) {
                query = query.concat(" and visibleOnly = true");
            }
            return this.getHibernateTemplate().find(query, (Object)setId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public List<PredefinedNewsConfiguration> getPredefinedNewsConfigurations() {
        try {
            String query = "from NewsDefinition def where def.class = PredefinedNewsDefinition order by def.name";
            return this.getHibernateTemplate().find(query);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public List<PredefinedNewsDefinition> getHiddenPredefinedNewsDefinitions(Long setId, Set<String> roles) {
        try {
            String query = "from PredefinedNewsDefinition def where :setId not in (select config.newsSet.id from def.userConfigurations config) ";
            for (int i = 0; i < roles.size(); ++i) {
                query = query.concat("and :role" + i + " not in elements(def.defaultRoles) ");
            }
            Query q = this.getSession().createQuery(query);
            q.setLong("setId", setId.longValue());
            int count = 0;
            for (String role : roles) {
                q.setString("role" + count, role);
                ++count;
            }
            return q.list();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void initNews(NewsSet set, Set<String> roles) {
        try {
            if (roles.isEmpty()) {
                return;
            }
            String query = "from PredefinedNewsDefinition def left join fetch def.defaultRoles role where :setId not in (select config.newsSet.id from def.userConfigurations config)";
            if (roles.size() > 0) {
                query = query.concat("and role in (:roles)");
            }
            Query q = this.getSession().createQuery(query);
            q.setLong("setId", set.getId().longValue());
            if (roles.size() > 0) {
                q.setParameterList("roles", roles);
            }
            List defs = q.list();
            for (PredefinedNewsDefinition def : defs) {
                PredefinedNewsConfiguration config = new PredefinedNewsConfiguration();
                config.setNewsDefinition(def);
                set.addNewsConfiguration(config);
            }
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PredefinedNewsDefinition getPredefinedNewsDefinition(Long id) {
        try {
            String query = "from PredefinedNewsDefinition def left join fetch def.defaultRoles role where def.id = :id";
            Query q = this.getSession().createQuery(query);
            q.setLong("id", id.longValue());
            return (PredefinedNewsDefinition)q.uniqueResult();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public NewsDefinition getNewsDefinition(Long id) {
        try {
            return (NewsDefinition)this.getHibernateTemplate().get(NewsDefinition.class, (Serializable)id);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public NewsConfiguration getNewsConfiguration(Long id) {
        try {
            return (NewsConfiguration)this.getHibernateTemplate().load(NewsConfiguration.class, (Serializable)id);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void deleteNewsConfiguration(NewsConfiguration configuration) {
        try {
            this.getHibernateTemplate().delete((Object)configuration);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void deleteNewsDefinition(PredefinedNewsDefinition definition) {
        try {
            String query = "from NewsConfiguration config where config.newsDefinition.id = ? and config.class = PredefinedNewsConfiguration";
            List configs = this.getHibernateTemplate().find(query, (Object)definition.getId());
            this.getHibernateTemplate().deleteAll((Collection)configs);
            this.getHibernateTemplate().delete((Object)definition);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public List<String> getUserRoles() {
        try {
            String query = "select distinct elements(def.defaultRoles) from PredefinedNewsDefinition def ";
            return this.getHibernateTemplate().find(query);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public NewsSet getNewsSet(Long id) {
        try {
            return (NewsSet)this.getHibernateTemplate().get(NewsSet.class, (Serializable)id);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public List<NewsSet> getNewsSetsForUser(String userId) {
        try {
            log.debug((Object)("fetching news sets for " + userId));
            return this.getHibernateTemplate().find("from NewsSet newsSet where newsSet.userId = ? order by newsSet.name", (Object)userId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void storeNewsSet(NewsSet set) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)set);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public NewsSet getNewsSet(String userId, String setName) {
        try {
            log.debug((Object)("fetching news sets for " + userId));
            String query = "from NewsSet newsSet where :userId = newsSet.userId and :setName = newsSet.name order by newsSet.name";
            Query q = this.getSession().createQuery(query);
            q.setString("userId", userId);
            q.setString("setName", setName);
            return (NewsSet)q.uniqueResult();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }
}

