/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.adapter;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.adapter.INewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class RomeAdapter
implements INewsAdapter {
    private static Log log = LogFactory.getLog(RomeAdapter.class);
    private Cache cache;
    private String policyFile;

    public SyndFeed getSyndFeed(NewsConfiguration config, PortletRequest request) throws NewsException {
        SyndFeed feed = null;
        String url = config.getNewsDefinition().getParameters().get("url");
        String key = this.getCacheKey(url);
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            log.debug((Object)"Cache miss");
            feed = this.getSyndFeed(url, request.getPortletSession().getPortletContext().getRealPath("/") + this.policyFile);
            cachedElement = new Element((Object)key, (Object)feed);
            this.cache.put(cachedElement);
        } else {
            log.debug((Object)"Cache hit");
            feed = (SyndFeed)cachedElement.getValue();
        }
        return feed;
    }

    protected SyndFeed getSyndFeed(String url, String policyFile) throws NewsException {
        SyndFeedInput input = new SyndFeedInput();
        HttpClient client = new HttpClient();
        GetMethod get = null;
        try {
            int rc;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving feed " + url));
            }
            if ((rc = client.executeMethod((HttpMethod)(get = new GetMethod(url)))) != 200) {
                log.warn((Object)("HttpStatus for " + url + ":" + rc));
            }
            InputStream in = get.getResponseBodyAsStream();
            SyndFeed feed = input.build((Reader)new XmlReader(in));
            AntiSamy as = new AntiSamy();
            List a = feed.getEntries();
            Policy policy = Policy.getInstance((String)policyFile);
            for (SyndEntry entry : a) {
                SyndContent description = entry.getDescription();
                CleanResults cr = as.scan(description.getValue(), policy);
                description.setValue(cr.getCleanHTML());
                entry.setDescription(description);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("SyndEntry '" + entry.getTitle() + "' cleaned in " + cr.getScanTime() + " seconds"));
            }
            SyndFeed syndFeed = feed;
            return syndFeed;
        }
        catch (PolicyException e) {
            log.warn((Object)"Error fetching feed", (Throwable)e);
            throw new NewsException("Error fetching feed");
        }
        catch (ScanException e) {
            log.warn((Object)"Error fetching feed", (Throwable)e);
            throw new NewsException("Error fetching feed");
        }
        catch (HttpException e) {
            log.warn((Object)"Error fetching feed", (Throwable)e);
            throw new NewsException("Error fetching feed");
        }
        catch (IOException e) {
            log.warn((Object)"Error fetching feed", (Throwable)e);
            throw new NewsException("Error fetching feed");
        }
        catch (FeedException e) {
            log.warn((Object)"Error parsing feed: ", (Throwable)e);
            throw new NewsException("Error parsing feed");
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    private String getCacheKey(String url) {
        StringBuffer key = new StringBuffer();
        key.append("RomeFeed.");
        key.append(url);
        return key.toString();
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setPolicyFile(String policyFile) {
        this.policyFile = policyFile;
    }
}

