/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.portlet.PortletException;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.ResourceFilter;
import javax.portlet.filter.ResourceResponseWrapper;
import javax.servlet.ServletOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.DigestUtils;
import org.springframework.util.FileCopyUtils;

public class ShallowEtagHeaderPortletFilter
implements ResourceFilter {
    private static String HEADER_IF_NONE_MATCH = "If-None-Match";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws PortletException {
    }

    public void doFilter(ResourceRequest request, ResourceResponse response, FilterChain filterChain) throws IOException, PortletException {
        ShallowEtagResponseWrapper responseWrapper = new ShallowEtagResponseWrapper(response);
        filterChain.doFilter(request, (ResourceResponse)responseWrapper);
        byte[] body = responseWrapper.toByteArray();
        int statusCode = responseWrapper.getStatusCode();
        if (this.isEligibleForEtag(request, (ResourceResponse)responseWrapper, statusCode, body)) {
            String responseETag = this.generateETagHeaderValue(body);
            response.setProperty("portlet.ETag", responseETag);
            response.getCacheControl().setETag(responseETag);
            String requestETag = request.getProperty(HEADER_IF_NONE_MATCH);
            if (responseETag.equals(requestETag)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("ETag [" + responseETag + "] equal to If-None-Match, sending 304"));
                }
                response.setContentLength(0);
                response.setProperty("portlet.http-status-code", String.valueOf(304));
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("ETag [" + responseETag + "] not equal to If-None-Match [" + requestETag + "], sending normal response"));
                }
                this.copyBodyToResponse(body, response);
            }
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Response with status code [" + statusCode + "] not eligible for ETag"));
            }
            this.copyBodyToResponse(body, response);
        }
    }

    private void copyBodyToResponse(byte[] body, ResourceResponse response) throws IOException {
        response.setContentLength(body.length);
        if (body.length > 0) {
            FileCopyUtils.copy((byte[])body, (OutputStream)response.getPortletOutputStream());
        }
    }

    protected boolean isEligibleForEtag(ResourceRequest request, ResourceResponse response, int responseStatusCode, byte[] responseBody) {
        return responseStatusCode >= 200 && responseStatusCode < 300;
    }

    protected String generateETagHeaderValue(byte[] bytes) {
        StringBuilder builder = new StringBuilder("\"0");
        DigestUtils.appendMd5DigestAsHex((byte[])bytes, (StringBuilder)builder);
        builder.append('\"');
        return builder.toString();
    }

    private static class ShallowEtagResponseWrapper
    extends ResourceResponseWrapper {
        private final ByteArrayOutputStream content = new ByteArrayOutputStream();
        private final ServletOutputStream outputStream = new ResponseServletOutputStream();
        private PrintWriter writer;
        private int statusCode = 200;

        private ShallowEtagResponseWrapper(ResourceResponse response) {
            super(response);
        }

        public void setProperty(String name, String value) {
            super.setProperty(name, value);
            if ("portlet.http-status-code".equals(name)) {
                this.statusCode = Integer.parseInt(value);
            }
        }

        public ServletOutputStream getPortletOutputStream() {
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                String characterEncoding = this.getCharacterEncoding();
                this.writer = characterEncoding != null ? new ResponsePrintWriter(characterEncoding) : new ResponsePrintWriter("ISO-8859-1");
            }
            return this.writer;
        }

        public void resetBuffer() {
            this.content.reset();
        }

        public void reset() {
            super.reset();
            this.resetBuffer();
        }

        private int getStatusCode() {
            return this.statusCode;
        }

        private byte[] toByteArray() {
            return this.content.toByteArray();
        }

        private class ResponsePrintWriter
        extends PrintWriter {
            private ResponsePrintWriter(String characterEncoding) throws UnsupportedEncodingException {
                super(new OutputStreamWriter((OutputStream)ShallowEtagResponseWrapper.this.content, characterEncoding));
            }

            public void write(char[] buf, int off, int len) {
                super.write(buf, off, len);
                super.flush();
            }

            public void write(String s, int off, int len) {
                super.write(s, off, len);
                super.flush();
            }

            public void write(int c) {
                super.write(c);
                super.flush();
            }
        }

        private class ResponseServletOutputStream
        extends ServletOutputStream {
            private ResponseServletOutputStream() {
            }

            public void write(int b) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b, off, len);
            }
        }
    }
}

