/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.PredefinedNewsDefinition;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.mvc.NewsDefinitionForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class EditNewsDefinitionController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private NewsStore newsStore;

    @ModelAttribute(value="form")
    protected Object formBackingObject(PortletRequest request) throws Exception {
        String id = request.getParameter("id");
        if (id != null && !id.equals("")) {
            Long definitionId = Long.parseLong(id);
            if (definitionId > -1L) {
                PredefinedNewsDefinition definition = this.newsStore.getPredefinedNewsDefinition(definitionId);
                NewsDefinitionForm command = new NewsDefinitionForm();
                command.setId(definition.getId());
                command.setName(definition.getName());
                command.setClassName(definition.getClassName());
                command.setRole(definition.getDefaultRoles());
                command.addParameters(definition.getParameters());
                return command;
            }
            return new NewsDefinitionForm();
        }
        return new NewsDefinitionForm();
    }

    @RequestMapping
    protected void onSubmitAction(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        NewsDefinitionForm form = (NewsDefinitionForm)command;
        PredefinedNewsDefinition definition = null;
        definition = form.getId() > -1L ? this.newsStore.getPredefinedNewsDefinition(form.getId()) : new PredefinedNewsDefinition();
        definition.setClassName(form.getClassName());
        definition.setDefaultRoles(form.getRole());
        definition.setName(form.getName());
        definition.setParameters(form.getParameters());
        this.newsStore.storeNewsDefinition(definition);
        response.setRenderParameter("action", "administration");
    }

    @Autowired(required=true)
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }
}

