/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.PredefinedNewsConfiguration;
import org.jasig.portlet.newsreader.PredefinedNewsDefinition;
import org.jasig.portlet.newsreader.UserDefinedNewsConfiguration;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"EDIT"})
public class EditNewsPreferencesController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Map predefinedEditActions;
    private NewsStore newsStore;

    @RequestMapping
    public ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletSession session = request.getPortletSession();
        Long setId = (Long)session.getAttribute("setId", 2);
        NewsSet set = this.newsStore.getNewsSet(setId);
        Set<NewsConfiguration> configurations = set.getNewsConfigurations();
        ArrayList<UserDefinedNewsConfiguration> myNewsConfigurations = new ArrayList<UserDefinedNewsConfiguration>();
        ArrayList<PredefinedNewsConfiguration> predefinedNewsConfigurations = new ArrayList<PredefinedNewsConfiguration>();
        for (NewsConfiguration configuration : configurations) {
            if (configuration instanceof UserDefinedNewsConfiguration) {
                myNewsConfigurations.add((UserDefinedNewsConfiguration)configuration);
                continue;
            }
            if (!(configuration instanceof PredefinedNewsConfiguration)) continue;
            predefinedNewsConfigurations.add((PredefinedNewsConfiguration)configuration);
        }
        model.put("myNewsConfigurations", myNewsConfigurations);
        model.put("predefinedNewsConfigurations", predefinedNewsConfigurations);
        Set userRoles = (Set)session.getAttribute("userRoles", 2);
        List<PredefinedNewsDefinition> definitions = this.newsStore.getHiddenPredefinedNewsDefinitions(setId, userRoles);
        model.put("hiddenFeeds", definitions);
        model.put("predefinedEditActions", this.predefinedEditActions);
        return new ModelAndView("/editNews", "model", model);
    }

    public void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        Long id = Long.parseLong(request.getParameter("id"));
        String actionCode = request.getParameter("actionCode");
        PortletSession session = request.getPortletSession();
        Long setId = (Long)session.getAttribute("setId", 2);
        NewsSet set = this.newsStore.getNewsSet(setId);
        if (actionCode.equals("delete")) {
            NewsConfiguration config = this.newsStore.getNewsConfiguration(id);
            this.newsStore.deleteNewsConfiguration(config);
        } else if (actionCode.equals("show")) {
            NewsConfiguration config = this.newsStore.getNewsConfiguration(id);
            config.setDisplayed(true);
            this.newsStore.storeNewsConfiguration(config);
        } else if (actionCode.equals("hide")) {
            NewsConfiguration config = this.newsStore.getNewsConfiguration(id);
            config.setDisplayed(false);
            this.newsStore.storeNewsConfiguration(config);
        } else if (actionCode.equals("showNew")) {
            PredefinedNewsDefinition definition = (PredefinedNewsDefinition)this.newsStore.getNewsDefinition(id);
            this.log.debug((Object)("definition to save " + definition.toString()));
            PredefinedNewsConfiguration config = new PredefinedNewsConfiguration();
            config.setNewsDefinition(definition);
            config.setNewsSet(set);
            this.newsStore.storeNewsConfiguration(config);
        }
    }

    public void setPredefinedEditActions(Map predefinedEditActions) {
        this.predefinedEditActions = predefinedEditActions;
    }

    @Autowired(required=true)
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }
}

