/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.UserDefinedNewsConfiguration;
import org.jasig.portlet.newsreader.UserDefinedNewsDefinition;
import org.jasig.portlet.newsreader.adapter.RomeAdapter;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.mvc.NewsListingCommand;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class EditUserRomeController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private NewsStore newsStore;
    private NewsSetResolvingService setCreationService;

    @RequestMapping(params={"action=editUrl"})
    public String showEditForm() {
        return "editNewsUrl";
    }

    @ModelAttribute(value="form")
    protected Object formBackingObject(PortletRequest request) throws Exception {
        String id = request.getParameter("id");
        if (id != null && !id.equals("")) {
            Long configurationId = Long.parseLong(id);
            if (configurationId > -1L) {
                NewsConfiguration listing = this.newsStore.getNewsConfiguration(configurationId);
                this.log.debug((Object)("retrieved " + listing.toString()));
                NewsListingCommand command = new NewsListingCommand();
                command.setId(listing.getId());
                command.setName(listing.getNewsDefinition().getName());
                command.setUrl(listing.getNewsDefinition().getParameters().get("url"));
                command.setDisplayed(listing.isDisplayed());
                return command;
            }
            return new NewsListingCommand();
        }
        return new NewsListingCommand();
    }

    @RequestMapping(params={"action=editPreferences"})
    protected void onSubmitAction(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        NewsListingCommand form = (NewsListingCommand)command;
        UserDefinedNewsConfiguration config = null;
        UserDefinedNewsDefinition definition = null;
        if (form.getId() > -1L) {
            config = (UserDefinedNewsConfiguration)this.newsStore.getNewsConfiguration(form.getId());
            definition = config.getNewsDefinition();
            definition.addParameter("url", form.getUrl());
            definition.setName(form.getName());
            this.log.debug((Object)"Updating");
        } else {
            definition = new UserDefinedNewsDefinition();
            definition.setClassName(RomeAdapter.class.getName());
            definition.addParameter("url", form.getUrl());
            definition.setName(form.getName());
            this.newsStore.storeNewsDefinition(definition);
            config = new UserDefinedNewsConfiguration();
            config.setNewsDefinition(definition);
            config.setDisplayed(form.isDisplayed());
            PortletSession session = request.getPortletSession();
            Long setId = (Long)session.getAttribute("setId", 2);
            config.setNewsSet(this.setCreationService.getNewsSet(setId, request));
            this.log.debug((Object)"Insert new");
        }
        this.log.debug((Object)("User defined News definition is " + config.getNewsDefinition().getName()));
        this.newsStore.storeNewsConfiguration(config);
        response.setRenderParameter("action", "editPreferences");
    }

    @Autowired(required=true)
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    @Autowired(required=true)
    public void setSetCreationService(NewsSetResolvingService setCreationService) {
        this.setCreationService = setCreationService;
    }
}

