/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.singlefeed;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.service.IInitializationService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"VIEW"})
public class SingleFeedNewsController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private List<IInitializationService> initializationServices = Collections.emptyList();
    private String viewName = "viewSingleFeed";

    @Resource(name="initializationServices")
    public void setInitializationServices(List<IInitializationService> services) {
        this.initializationServices = services;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @RequestMapping
    public ModelAndView getSingleFeedView(RenderRequest request, RenderResponse response) throws Exception {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        PortletSession session = request.getPortletSession(true);
        if (session.getAttribute("initialized") == null) {
            for (IInitializationService service : this.initializationServices) {
                service.initialize((PortletRequest)request);
            }
            session.setAttribute("initialized", (Object)"true");
        }
        PortletPreferences portletPrefs = request.getPreferences();
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("summaryView", portletPrefs.getValue("summaryView", ""));
        preferences.put("maxStories", portletPrefs.getValue("maxStories", ""));
        preferences.put("newWindow", portletPrefs.getValue("newWindow", Boolean.TRUE.toString()));
        model.put("prefs", preferences);
        boolean supportsEdit = request.isPortletModeAllowed(PortletMode.EDIT);
        model.put("supportsEdit", Boolean.valueOf(supportsEdit));
        this.log.debug((Object)("forwarding to " + this.viewName));
        return new ModelAndView(this.viewName, model);
    }
}

