/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.filter;

import java.io.IOException;
import java.io.OutputStream;
import javax.portlet.PortletException;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.ResourceFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.mvc.filter.ShallowEtagHeaderPortletFilter;
import org.springframework.util.DigestUtils;
import org.springframework.util.FileCopyUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShallowEtagHeaderPortletFilter
implements ResourceFilter {
    private static String HEADER_IF_NONE_MATCH = "If-None-Match";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws PortletException {
    }

    public void doFilter(ResourceRequest request, ResourceResponse response, FilterChain filterChain) throws IOException, PortletException {
        ShallowEtagResponseWrapper responseWrapper = new ShallowEtagResponseWrapper(response, null);
        filterChain.doFilter(request, (ResourceResponse)responseWrapper);
        byte[] body = ShallowEtagResponseWrapper.access$100((ShallowEtagResponseWrapper)responseWrapper);
        int statusCode = ShallowEtagResponseWrapper.access$200((ShallowEtagResponseWrapper)responseWrapper);
        if (this.isEligibleForEtag(request, (ResourceResponse)responseWrapper, statusCode, body)) {
            String responseETag = this.generateETagHeaderValue(body);
            response.setProperty("portlet.ETag", responseETag);
            response.getCacheControl().setETag(responseETag);
            String requestETag = request.getProperty(HEADER_IF_NONE_MATCH);
            if (responseETag.equals(requestETag)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("ETag [" + responseETag + "] equal to If-None-Match, sending 304"));
                }
                response.setContentLength(0);
                response.setProperty("portlet.http-status-code", String.valueOf(304));
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("ETag [" + responseETag + "] not equal to If-None-Match [" + requestETag + "], sending normal response"));
                }
                this.copyBodyToResponse(body, response);
            }
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Response with status code [" + statusCode + "] not eligible for ETag"));
            }
            this.copyBodyToResponse(body, response);
        }
    }

    private void copyBodyToResponse(byte[] body, ResourceResponse response) throws IOException {
        response.setContentLength(body.length);
        if (body.length > 0) {
            FileCopyUtils.copy((byte[])body, (OutputStream)response.getPortletOutputStream());
        }
    }

    protected boolean isEligibleForEtag(ResourceRequest request, ResourceResponse response, int responseStatusCode, byte[] responseBody) {
        return responseStatusCode >= 200 && responseStatusCode < 300;
    }

    protected String generateETagHeaderValue(byte[] bytes) {
        StringBuilder builder = new StringBuilder("\"0");
        DigestUtils.appendMd5DigestAsHex((byte[])bytes, (StringBuilder)builder);
        builder.append('\"');
        return builder.toString();
    }
}

