/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.service.IInitializationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"VIEW"})
public class NewsController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private NewsStore newsStore;
    private int defaultItems = 2;
    private List<IInitializationService> initializationServices;
    private String viewName = "viewNews";

    @Autowired(required=true)
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    public void setDefaultItems(int defaultItems) {
        this.defaultItems = defaultItems;
    }

    @Resource(name="initializationServices")
    public void setInitializationServices(List<IInitializationService> services) {
        this.initializationServices = services;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @RequestMapping
    public ModelAndView showNewsView(RenderRequest request, RenderResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletSession session = request.getPortletSession(true);
        if (session.getAttribute("initialized") == null) {
            List allRoles = this.newsStore.getUserRoles();
            this.log.debug((Object)("all roles: " + allRoles));
            HashSet<String> userRoles = new HashSet<String>();
            for (String role : allRoles) {
                if (!request.isUserInRole(role)) continue;
                userRoles.add(role);
            }
            session.setAttribute("userRoles", userRoles, 2);
            session.setAttribute("isAdmin", (Object)request.isUserInRole("newsAdmin"), 2);
            session.setAttribute("items", (Object)this.defaultItems);
            for (IInitializationService service : this.initializationServices) {
                service.initialize((PortletRequest)request);
            }
            session.setAttribute("initialized", (Object)"true");
            session.setMaxInactiveInterval(7200);
        }
        model.put("supportsHelp", request.isPortletModeAllowed(PortletMode.HELP));
        model.put("supportsEdit", request.isPortletModeAllowed(PortletMode.EDIT));
        model.put("isAdmin", session.getAttribute("isAdmin", 2));
        this.log.debug((Object)("forwarding to " + this.viewName));
        return new ModelAndView(this.viewName, model);
    }
}

