/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.singlefeed;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.Preference;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class EditSingleFeedPreferencesController
implements InitializingBean {
    protected final Log log = LogFactory.getLog(this.getClass());
    private List<Integer> optionsMaxStories;
    private Map<String, String> optionsViewTypes;

    public void afterPropertiesSet() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("flyout", "a list with flyouts");
        m.put("titleAndAbstract", "a list of titles with summaries");
        m.put("title", "a list of titles only");
        this.optionsViewTypes = Collections.unmodifiableMap(m);
        this.optionsMaxStories = Arrays.asList(5, 10, 15, 20);
    }

    @RequestMapping
    protected ModelAndView showEditForm(RenderRequest request, RenderResponse response) throws Exception {
        this.log.trace((Object)"handleRenderRequestInternal");
        PortletPreferences preferences = request.getPreferences();
        HashMap<String, Preference> model = new HashMap<String, Preference>();
        Preference max = new Preference();
        max.setOptions((Object)this.optionsMaxStories);
        max.setValue(preferences.getValue("maxStories", ""));
        max.setReadOnly(preferences.isReadOnly("maxStories"));
        model.put("max", max);
        Preference view = new Preference();
        view.setOptions((Object)this.optionsViewTypes);
        view.setValue(preferences.getValue("summaryView", ""));
        view.setReadOnly(preferences.isReadOnly("summaryView"));
        model.put("view", view);
        Preference newWindow = new Preference();
        newWindow.setValue(preferences.getValue("newWindow", Boolean.TRUE.toString()));
        newWindow.setReadOnly(preferences.isReadOnly("newWindow"));
        model.put("newWindow", newWindow);
        return new ModelAndView("editSingleFeed", model);
    }

    @ResourceMapping
    public ModelAndView saveDisplayPreference(@RequestParam String prefName, @RequestParam String prefValue, PortletRequest request) throws Exception {
        try {
            PortletPreferences prefs = request.getPreferences();
            prefs.setValue(prefName, prefValue);
            prefs.store();
            return new ModelAndView("jsonView", Collections.singletonMap("status", "success"));
        }
        catch (Exception e) {
            this.log.error((Object)"There was an error saving the preferences.", (Throwable)e);
            return new ModelAndView("jsonView", Collections.singletonMap("status", "error"));
        }
    }
}

