/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.processor;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.mediarss.MediaEntryModule;
import com.sun.syndication.feed.module.mediarss.types.MediaContent;
import com.sun.syndication.feed.module.mediarss.types.MediaGroup;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.model.NewsFeedItem;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.core.io.Resource;

public class RomeNewsProcessorImpl {
    protected final Log log = LogFactory.getLog(this.getClass());
    private List<String> imageTypes;
    private Map<String, Policy> policies = new HashMap();

    public SyndFeed getFeed(InputStream in, String titlePolicy, String descriptionPolicy) throws IOException, IllegalArgumentException, FeedException, PolicyException, ScanException {
        XmlReader reader = new XmlReader(in);
        SyndFeedInput input = new SyndFeedInput();
        SyndFeed feed = input.build((Reader)reader);
        ArrayList<NewsFeedItem> newEntries = new ArrayList<NewsFeedItem>();
        List entries = feed.getEntries();
        for (SyndEntry entry : entries) {
            NewsFeedItem item = this.getNewsFeedItem(entry, titlePolicy, descriptionPolicy);
            newEntries.add(item);
        }
        feed.setEntries(newEntries);
        return feed;
    }

    protected NewsFeedItem getNewsFeedItem(SyndEntry entry, String titlePolicy, String descriptionPolicy) throws PolicyException, ScanException {
        Module mediaModule;
        NewsFeedItem item = new NewsFeedItem();
        item.copyFrom((Object)entry);
        AntiSamy as = new AntiSamy();
        CleanResults cr = null;
        double scanTime = 0.0;
        if (item.getDescription() != null && item.getDescription().getValue() != null) {
            cr = as.scan(item.getDescription().getValue(), (Policy)this.policies.get(descriptionPolicy));
            item.getDescription().setValue(cr.getCleanHTML());
            scanTime += cr.getScanTime();
        }
        if (item.getTitle() != null) {
            cr = as.scan(item.getTitle(), (Policy)this.policies.get(titlePolicy));
            item.setTitle(cr.getCleanHTML());
            scanTime += cr.getScanTime();
        }
        if (this.log.isDebugEnabled() && cr != null) {
            this.log.debug((Object)("SyndEntry '" + entry.getTitle() + "' cleaned in " + cr.getScanTime() + " seconds"));
        }
        List enclosures = entry.getEnclosures();
        for (SyndEnclosure enclosure : enclosures) {
            String type = enclosure.getType();
            if (!StringUtils.isNotBlank((String)type) || !this.imageTypes.contains(type)) continue;
            item.setImageUrl(enclosure.getUrl());
            break;
        }
        if ((mediaModule = entry.getModule("http://search.yahoo.com/mrss/")) != null && mediaModule instanceof MediaEntryModule) {
            MediaEntryModule mentry = (MediaEntryModule)mediaModule;
            for (MediaGroup mediaGroup : mentry.getMediaGroups()) {
                for (MediaContent mc : mediaGroup.getContents()) {
                    String type = mc.getType();
                    if (!StringUtils.isNotBlank((String)type) || !this.imageTypes.contains(type)) continue;
                    item.setImageUrl(mc.getReference().toString());
                }
            }
            for (MediaGroup mediaGroup : mentry.getMediaContents()) {
                String type = mediaGroup.getType();
                if (!StringUtils.isNotBlank((String)type) || !this.imageTypes.contains(type)) continue;
                item.setImageUrl(mediaGroup.getReference().toString());
            }
        }
        return item;
    }

    public void setPolicies(Map<String, Resource> policies) throws PolicyException, IOException {
        for (Map.Entry<String, Resource> policy : policies.entrySet()) {
            InputStream policyStream = policy.getValue().getInputStream();
            this.policies.put(policy.getKey(), Policy.getInstance((InputStream)policyStream));
            policyStream.close();
        }
    }

    public void setImageTypes(List<String> imageTypes) {
        this.imageTypes = imageTypes;
    }
}

