/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.service;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.portlet.PortletRequest;
import org.jasig.portlet.newsreader.service.IViewResolver;

public class ViewResolverImpl
implements IViewResolver {
    private List<Pattern> mobileDeviceRegexes = null;

    public void setMobileDeviceRegexes(List<String> patterns) {
        this.mobileDeviceRegexes = new ArrayList();
        for (String pattern : patterns) {
            this.mobileDeviceRegexes.add(Pattern.compile(pattern));
        }
    }

    public String getSingleFeedView(PortletRequest request) {
        if (this.isMobile(request)) {
            return "viewSingleFeed-jQM";
        }
        return "viewSingleFeed";
    }

    public String getReaderView(PortletRequest request) {
        if (this.isMobile(request)) {
            return "viewNews-jQM";
        }
        return "viewNews";
    }

    public String getPreferencesView(PortletRequest request) {
        if (this.isMobile(request)) {
            return "editNews-jQM";
        }
        return "editNews";
    }

    protected boolean isMobile(PortletRequest request) {
        String userAgent = request.getProperty("user-agent");
        if (this.mobileDeviceRegexes != null && userAgent != null) {
            for (Pattern regex : this.mobileDeviceRegexes) {
                if (!regex.matcher(userAgent).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

