/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.processor;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.mediarss.MediaEntryModule;
import com.sun.syndication.feed.module.mediarss.types.MediaContent;
import com.sun.syndication.feed.module.mediarss.types.MediaGroup;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.model.NewsFeed;
import org.jasig.portlet.newsreader.model.NewsFeedItem;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.core.io.Resource;

public class RomeNewsProcessorImpl {
    protected final Log log = LogFactory.getLog(this.getClass());
    private List<String> imageTypes;
    private List<String> videoTypes;
    private Map<String, Policy> policies = new HashMap<String, Policy>();

    public void setImageTypes(List<String> imageTypes) {
        this.imageTypes = imageTypes;
    }

    public void setVideoTypes(List<String> videoTypes) {
        this.videoTypes = videoTypes;
    }

    public NewsFeed getFeed(InputStream in, String titlePolicy, String descriptionPolicy) throws IOException, IllegalArgumentException, FeedException, PolicyException, ScanException {
        XmlReader reader = new XmlReader(in);
        SyndFeedInput input = new SyndFeedInput();
        SyndFeed feed = input.build((Reader)reader);
        NewsFeed newsFeed = new NewsFeed();
        newsFeed.setAuthor(feed.getAuthor());
        newsFeed.setLink(feed.getLink());
        newsFeed.setTitle(feed.getTitle());
        newsFeed.setCopyright(feed.getCopyright());
        ArrayList<NewsFeedItem> newEntries = new ArrayList<NewsFeedItem>();
        List entries = feed.getEntries();
        for (SyndEntry entry : entries) {
            NewsFeedItem item = this.getNewsFeedItem(entry, titlePolicy, descriptionPolicy);
            newEntries.add(item);
        }
        newsFeed.setEntries(newEntries);
        return newsFeed;
    }

    protected NewsFeedItem getNewsFeedItem(SyndEntry entry, String titlePolicy, String descriptionPolicy) throws PolicyException, ScanException {
        Module mediaModule;
        NewsFeedItem item = new NewsFeedItem();
        item.setAuthors(entry.getAuthors());
        item.setLink(entry.getLink());
        item.setUri(entry.getUri());
        if (entry.getContents() != null) {
            for (SyndContent content : entry.getContents()) {
                if (!"html".equals(content.getType())) continue;
                item.setContent(content.getValue());
            }
        }
        AntiSamy as = new AntiSamy();
        CleanResults cr = null;
        double scanTime = 0.0;
        if (entry.getDescription() != null && entry.getDescription().getValue() != null) {
            cr = as.scan(entry.getDescription().getValue(), this.policies.get(descriptionPolicy));
            item.setDescription(cr.getCleanHTML());
            scanTime += cr.getScanTime();
        } else if (item.getContent() != null) {
            cr = as.scan(item.getContent(), this.policies.get(descriptionPolicy));
            String desc = cr.getCleanHTML();
            if (desc.length() > 200) {
                desc = desc.substring(0, 197).concat("...");
            }
            item.setDescription(desc);
            scanTime += cr.getScanTime();
        }
        if (entry.getTitle() != null) {
            cr = as.scan(entry.getTitle(), this.policies.get(titlePolicy));
            item.setTitle(cr.getCleanHTML());
            scanTime += cr.getScanTime();
        }
        if (this.log.isDebugEnabled() && cr != null) {
            this.log.debug((Object)("SyndEntry '" + entry.getTitle() + "' cleaned in " + cr.getScanTime() + " seconds"));
        }
        List enclosures = entry.getEnclosures();
        for (SyndEnclosure enclosure : enclosures) {
            String type = enclosure.getType();
            if (StringUtils.isNotBlank((String)type) && this.videoTypes.contains(type)) {
                item.setVideoUrl(enclosure.getUrl());
                break;
            }
            if (!StringUtils.isNotBlank((String)type) || !this.imageTypes.contains(type)) continue;
            item.setImageUrl(enclosure.getUrl());
            break;
        }
        if ((mediaModule = entry.getModule("http://search.yahoo.com/mrss/")) != null && mediaModule instanceof MediaEntryModule) {
            MediaEntryModule mentry = (MediaEntryModule)mediaModule;
            for (MediaGroup mediaGroup : mentry.getMediaGroups()) {
                for (MediaContent mc : mediaGroup.getContents()) {
                    String type = mc.getType();
                    if (StringUtils.isNotBlank((String)type) && this.videoTypes.contains(type)) {
                        item.setVideoUrl(mc.getReference().toString());
                        break;
                    }
                    if (!StringUtils.isNotBlank((String)type) || !this.imageTypes.contains(type)) continue;
                    item.setImageUrl(mc.getReference().toString());
                    break;
                }
                if (item.getImageUrl() != null || mediaGroup.getMetadata().getThumbnail().length == 0) continue;
                item.setImageUrl(mediaGroup.getMetadata().getThumbnail()[0].getUrl().toString());
            }
            for (MediaGroup mediaGroup : mentry.getMediaContents()) {
                String type = mediaGroup.getType();
                if (StringUtils.isNotBlank((String)type) && this.videoTypes.contains(type)) {
                    item.setVideoUrl(mediaGroup.getReference().toString());
                    break;
                }
                if (!StringUtils.isNotBlank((String)type) || !this.imageTypes.contains(type)) continue;
                item.setImageUrl(mediaGroup.getReference().toString());
                break;
            }
        }
        return item;
    }

    public void setPolicies(Map<String, Resource> policies) throws PolicyException, IOException {
        for (Map.Entry<String, Resource> policy : policies.entrySet()) {
            InputStream policyStream = policy.getValue().getInputStream();
            this.policies.put(policy.getKey(), Policy.getInstance((InputStream)policyStream));
            policyStream.close();
        }
    }
}

