/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.adapter;

import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.adapter.INewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.portlet.newsreader.model.NewsFeed;
import org.jasig.portlet.newsreader.processor.RomeNewsProcessorImpl;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class RomeAdapter
implements INewsAdapter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private RomeNewsProcessorImpl processor;
    private Cache cache;

    public void setProcessor(RomeNewsProcessorImpl processor) {
        this.processor = processor;
    }

    public NewsFeed getSyndFeed(NewsConfiguration config, PortletRequest request) throws NewsException {
        NewsFeed feed = null;
        PortletPreferences prefs = request.getPreferences();
        String titlePolicy = prefs.getValue("titlePolicy", "antisamy-textonly");
        String descriptionPolicy = prefs.getValue("descriptionPolicy", "antisamy-textonly");
        String url = (String)config.getNewsDefinition().getParameters().get("url");
        String key = this.getCacheKey(url);
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            this.log.debug((Object)"Cache miss");
            feed = this.getSyndFeed(url, titlePolicy, descriptionPolicy);
            cachedElement = new Element((Serializable)((Object)key), (Serializable)feed);
            this.cache.put(cachedElement);
        } else {
            this.log.debug((Object)"Cache hit");
            feed = (NewsFeed)cachedElement.getValue();
        }
        return feed;
    }

    protected NewsFeed getSyndFeed(String url, String titlePolicy, String descriptionPolicy) throws NewsException {
        HttpClient client = new HttpClient();
        GetMethod get = null;
        NewsFeed feed = null;
        try {
            InputStream in;
            int rc;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieving feed " + url));
            }
            if ((rc = client.executeMethod((HttpMethod)(get = new GetMethod(url)))) != 200) {
                this.log.warn((Object)("HttpStatus for " + url + ":" + rc));
            }
            if ((in = get.getResponseBodyAsStream()) != null) {
                feed = this.processor.getFeed(in, titlePolicy, descriptionPolicy);
            } else {
                this.log.warn((Object)("Feed response not available or cannot be read. URL=" + url));
            }
            NewsFeed newsFeed = feed;
            return newsFeed;
        }
        catch (PolicyException e) {
            this.log.warn((Object)"Error fetching feed", (Throwable)e);
            throw new NewsException("Error fetching feed");
        }
        catch (ScanException e) {
            this.log.warn((Object)"Error fetching feed", (Throwable)e);
            throw new NewsException("Error fetching feed");
        }
        catch (HttpException e) {
            this.log.warn((Object)"Error fetching feed", (Throwable)e);
            throw new NewsException("Error fetching feed");
        }
        catch (IOException e) {
            this.log.warn((Object)"Error fetching feed", (Throwable)e);
            throw new NewsException("Error fetching feed");
        }
        catch (FeedException e) {
            this.log.warn((Object)"Error parsing feed: ", (Throwable)e);
            throw new NewsException("Error parsing feed");
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    private String getCacheKey(String url) {
        StringBuffer key = new StringBuffer();
        key.append("RomeFeed.");
        key.append(url);
        return key.toString();
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

