/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.singlefeed;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsDefinition;
import org.jasig.portlet.newsreader.adapter.INewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.portlet.newsreader.model.NewsFeed;
import org.jasig.portlet.newsreader.mvc.AbstractNewsController;
import org.jasig.portlet.newsreader.service.IInitializationService;
import org.jasig.portlet.newsreader.service.IViewResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class SingleFeedNewsController
extends AbstractNewsController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private List<IInitializationService> initializationServices;
    private IViewResolver viewResolver;

    @Autowired(required=true)
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Resource(name="initializationServices")
    public void setInitializationServices(List<IInitializationService> services) {
        this.initializationServices = services;
    }

    @Autowired(required=true)
    public void setViewResolver(IViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    @RequestMapping
    public void defaultAction(ActionRequest request) {
    }

    @RequestMapping
    public ModelAndView showFeed(RenderRequest request, RenderResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletSession session = request.getPortletSession(true);
        if (session.getAttribute("initialized") == null) {
            for (IInitializationService service : this.initializationServices) {
                service.initialize((PortletRequest)request);
            }
            session.setAttribute("initialized", (Object)"true");
        }
        PortletPreferences prefs = request.getPreferences();
        NewsConfiguration feedConfig = this.getFeedConfiguration(prefs);
        NewsFeed feed = null;
        try {
            INewsAdapter adapter = (INewsAdapter)this.applicationContext.getBean(feedConfig.getNewsDefinition().getClassName(), INewsAdapter.class);
            feed = adapter.getSyndFeed(feedConfig, (PortletRequest)request);
            if (feed != null) {
                this.log.debug((Object)"Got feed from adapter");
                model.put("feed", feed);
            } else {
                this.log.warn((Object)"Failed to get feed from adapter.");
                model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.log.error((Object)("News class instance could not be found: " + ex.getMessage()));
            model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
        }
        catch (NewsException ex) {
            this.log.warn((Object)ex);
            model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
            model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
        }
        PortletPreferences portletPrefs = request.getPreferences();
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("summaryView", portletPrefs.getValue("summaryView", ""));
        preferences.put("maxStories", portletPrefs.getValue("maxStories", ""));
        preferences.put("newWindow", portletPrefs.getValue("newWindow", Boolean.TRUE.toString()));
        preferences.put("showTitle", portletPrefs.getValue("showTitle", Boolean.TRUE.toString()));
        model.put("prefs", preferences);
        String viewName = this.viewResolver.getSingleFeedView((PortletRequest)request);
        return new ModelAndView(viewName, model);
    }

    protected NewsConfiguration getFeedConfiguration(PortletPreferences prefs) {
        String url = prefs.getValue("url", null);
        String url2 = prefs.getValue("url2", null);
        String name = prefs.getValue("name", "portlet preference 'name' not set");
        String className = prefs.getValue("className", null);
        NewsDefinition feedDef = new NewsDefinition(new Long(1L), className, name);
        feedDef.addParameter("url", url);
        feedDef.addParameter("url2", url2);
        NewsConfiguration feedConfig = new NewsConfiguration();
        feedConfig.setNewsDefinition(feedDef);
        feedConfig.setId(new Long(1L));
        return feedConfig;
    }
}

