/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.adapter;

import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.params.HttpParams;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.adapter.AbstractNewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.portlet.newsreader.adapter.RomeAdapter;
import org.jasig.portlet.newsreader.model.NewsFeed;
import org.jasig.portlet.newsreader.processor.RomeNewsProcessorImpl;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class RomeAdapter
extends AbstractNewsAdapter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private RomeNewsProcessorImpl processor;
    private AbstractHttpClient httpClient;
    private HttpClient compressingClient;
    private String proxyHost = null;
    private String proxyPort = null;
    private int connectionTimeout = 3000;
    private int readTimeout = 10000;
    private long connectionManagerTimeout = 5000L;
    private int timesToRetry = 2;
    private Cache cache;

    public AbstractHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(AbstractHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getConnectionManagerTimeout() {
        return this.connectionManagerTimeout;
    }

    public void setConnectionManagerTimeout(long connectionManagerTimeout) {
        this.connectionManagerTimeout = connectionManagerTimeout;
    }

    public int getTimesToRetry() {
        return this.timesToRetry;
    }

    public void setTimesToRetry(int timesToRetry) {
        this.timesToRetry = timesToRetry;
    }

    public void setProcessor(RomeNewsProcessorImpl processor) {
        this.processor = processor;
    }

    public void init() throws Exception {
        HttpParams params = this.httpClient.getParams();
        params.setIntParameter("http.connection.timeout", this.connectionTimeout);
        params.setIntParameter("http.socket.timeout", this.readTimeout);
        params.setLongParameter("http.conn-manager.timeout", this.connectionManagerTimeout);
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(this));
        String proxyHost = null;
        String proxyPort = null;
        if (StringUtils.isBlank((String)this.proxyHost) && StringUtils.isBlank((String)this.proxyPort)) {
            this.log.trace((Object)"Checking for proxy configuration from system properties...");
            proxyHost = System.getProperty("http.proxyHost");
            proxyPort = System.getProperty("http.proxyPort");
            if (StringUtils.isNotBlank((String)proxyHost) && StringUtils.isNotBlank((String)proxyPort)) {
                this.log.debug((Object)"Found proxy configuration from system properties");
            }
        } else {
            this.log.debug((Object)"Using proxy settings from fields set during bean construction");
            proxyHost = this.proxyHost;
            proxyPort = this.proxyPort;
        }
        if (!StringUtils.isBlank((String)proxyHost) && !StringUtils.isBlank((String)proxyPort)) {
            HttpHost proxy = new HttpHost(proxyHost, Integer.valueOf(proxyPort).intValue());
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            this.log.debug((Object)("Using proxy configuration to retrieve news feeds: " + proxyHost + ":" + proxyPort));
        } else {
            this.log.debug((Object)"No proxy configuration is set. Proceeding normally...");
        }
        this.compressingClient = new DecompressingHttpClient((HttpClient)this.httpClient);
    }

    public NewsFeed getSyndFeed(NewsConfiguration config, PortletRequest request) throws NewsException {
        NewsFeed feed = null;
        PortletPreferences prefs = request.getPreferences();
        String titlePolicy = prefs.getValue("titlePolicy", "antisamy-textonly");
        String descriptionPolicy = prefs.getValue("descriptionPolicy", "antisamy-textonly");
        String url = (String)config.getNewsDefinition().getParameters().get("url");
        if (url == null) {
            throw new IllegalArgumentException("The url parameter was not found; this is a required portlet preference.");
        }
        String url2 = (String)config.getNewsDefinition().getParameters().get("url2");
        String key = this.getCacheKey(url);
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            this.log.debug((Object)"Cache miss");
            if (url2 == null) {
                feed = this.getSyndFeed(url, titlePolicy, descriptionPolicy);
            } else {
                try {
                    feed = this.getSyndFeed(url, titlePolicy, descriptionPolicy);
                }
                catch (NewsException ex) {
                    this.log.warn((Object)"Failed to load feed at the primary URL so trying URL2", (Throwable)ex);
                }
                if (feed == null) {
                    feed = this.getSyndFeed(url2, titlePolicy, descriptionPolicy);
                }
            }
            cachedElement = new Element((Serializable)((Object)key), (Serializable)feed);
            this.cache.put(cachedElement);
        } else {
            this.log.debug((Object)"Cache hit");
            feed = (NewsFeed)cachedElement.getValue();
        }
        return feed;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NewsFeed getSyndFeed(String url, String titlePolicy, String descriptionPolicy) throws NewsException {
        NewsFeed newsFeed;
        HttpGet get;
        block13: {
            get = null;
            NewsFeed feed = null;
            InputStream in = null;
            try {
                this.log.debug((Object)("Retrieving feed " + url));
                get = new HttpGet(url);
                HttpResponse httpResponse = this.compressingClient.execute((HttpUriRequest)get);
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    this.log.warn((Object)("HttpStatus for " + url + ":" + httpResponse));
                }
                if ((in = httpResponse.getEntity().getContent()) != null) {
                    feed = this.processor.getFeed(in, titlePolicy, descriptionPolicy);
                } else {
                    this.log.warn((Object)("Feed response not available or cannot be read. URL=" + url));
                }
                newsFeed = feed;
                if (in == null) break block13;
            }
            catch (PolicyException e) {
                try {
                    this.log.warn((Object)"Error fetching feed", (Throwable)e);
                    throw new NewsException("Error fetching feed", (Throwable)e);
                    catch (ScanException e2) {
                        this.log.warn((Object)"Error fetching feed", (Throwable)e2);
                        throw new NewsException("Error fetching feed", (Throwable)e2);
                    }
                    catch (IOException e3) {
                        this.log.warn((Object)"Error fetching feed", (Throwable)e3);
                        throw new NewsException("Error fetching feed", (Throwable)e3);
                    }
                    catch (FeedException e4) {
                        this.log.warn((Object)"Error parsing feed: ", (Throwable)e4);
                        throw new NewsException("Error parsing feed", (Throwable)e4);
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        IOUtils.closeQuietly(in);
                    }
                    if (get != null) {
                        get.releaseConnection();
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        if (get != null) {
            get.releaseConnection();
        }
        return newsFeed;
    }

    private String getCacheKey(String url) {
        StringBuffer key = new StringBuffer();
        key.append("RomeFeed.");
        key.append(url);
        return key.toString();
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    static /* synthetic */ int access$000(RomeAdapter x0) {
        return x0.timesToRetry;
    }
}

