/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.adapter.INewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.model.NewsFeed;
import org.jasig.portlet.newsreader.model.NewsFeedItem;
import org.jasig.portlet.newsreader.mvc.AbstractNewsController;
import org.jasig.portlet.newsreader.service.IInitializationService;
import org.jasig.portlet.newsreader.service.IViewResolver;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class NewsController
extends AbstractNewsController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private NewsStore newsStore;
    private int defaultItems = 2;
    private List<IInitializationService> initializationServices;
    private IViewResolver viewResolver;
    private ApplicationContext applicationContext;
    private NewsSetResolvingService setCreationService;

    @Autowired(required=true)
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    public void setDefaultItems(int defaultItems) {
        this.defaultItems = defaultItems;
    }

    @Resource(name="initializationServices")
    public void setInitializationServices(List<IInitializationService> services) {
        this.initializationServices = services;
    }

    @Autowired(required=true)
    public void setViewResolver(IViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    @ActionMapping
    public void defaultAction() {
    }

    @ModelAttribute
    public void getPreferences(RenderRequest request, Model model) {
        PortletPreferences prefs = request.getPreferences();
        model.addAttribute("storyView", (Object)prefs.getValue("summaryView", "flyout"));
        model.addAttribute("feedView", (Object)prefs.getValue("feedView", "select"));
        model.addAttribute("newWindow", (Object)Boolean.valueOf(prefs.getValue("newWindow", "true")));
    }

    @RenderMapping
    public String showMainView(RenderRequest request) throws Exception {
        HashMap model = new HashMap();
        PortletSession session = request.getPortletSession(true);
        if (session.getAttribute("initialized") == null) {
            List allRoles = this.newsStore.getUserRoles();
            this.log.debug((Object)("all roles: " + allRoles));
            HashSet<String> userRoles = new HashSet<String>();
            for (String role : allRoles) {
                if (!request.isUserInRole(role)) continue;
                userRoles.add(role);
            }
            session.setAttribute("userRoles", userRoles, 2);
            session.setAttribute("items", (Object)this.defaultItems);
            for (IInitializationService service : this.initializationServices) {
                service.initialize((PortletRequest)request);
            }
            session.setAttribute("initialized", (Object)true);
            session.setMaxInactiveInterval(7200);
        }
        return this.viewResolver.getReaderView((PortletRequest)request);
    }

    @RenderMapping(params={"action=fullStory"})
    public ModelAndView fullStory(@RequestParam Long activeFeed, @RequestParam int itemIndex, RenderRequest request, RenderResponse response, Model model) throws Exception {
        this.log.debug((Object)"fullStory (NewsController)");
        String setName = request.getPreferences().getValue("newsSetName", "default");
        NewsSet set = this.setCreationService.getNewsSet(setName, (PortletRequest)request);
        ArrayList feeds = new ArrayList();
        feeds.addAll(set.getNewsConfigurations());
        Collections.sort(feeds);
        ArrayList<String> knownFeeds = new ArrayList<String>();
        for (NewsConfiguration feed : feeds) {
            knownFeeds.add(String.valueOf(feed.getId()));
        }
        this.log.debug((Object)("Known feeds: " + ((Object)knownFeeds).toString()));
        if (!knownFeeds.contains(activeFeed.toString())) {
            activeFeed = null;
            model.addAttribute("message", (Object)"Not allowed.");
            this.log.debug((Object)"Not allowd.");
        }
        NewsConfiguration feedConfig = this.newsStore.getNewsConfiguration(activeFeed);
        this.log.debug((Object)("On render Active feed is " + feedConfig.getId()));
        try {
            INewsAdapter adapter = (INewsAdapter)this.applicationContext.getBean(feedConfig.getNewsDefinition().getClassName());
            NewsFeed sharedFeed = adapter.getSyndFeed(feedConfig, (PortletRequest)request);
            if (sharedFeed != null) {
                NewsFeedItem item = (NewsFeedItem)sharedFeed.getEntries().get(itemIndex);
                model.addAttribute("storyTitle", (Object)item.getTitle());
                model.addAttribute("fullStory", (Object)item.getFullStory());
            } else {
                this.log.warn((Object)"Failed to get feed from adapter.");
                model.addAttribute("message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.log.error((Object)("News class instance could not be found: " + ex.getMessage()));
            model.addAttribute("message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
        }
        catch (NewsException ex) {
            this.log.warn((Object)ex);
            model.addAttribute("message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
            model.addAttribute("message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
        }
        String etag = String.valueOf(model.hashCode());
        String requestEtag = request.getETag();
        if (request.getETag() != null && etag.equals(requestEtag)) {
            response.getCacheControl().setExpirationTime(1);
            response.getCacheControl().setUseCachedContent(true);
            return new ModelAndView("empty", Collections.emptyMap());
        }
        response.getCacheControl().setETag(etag);
        response.getCacheControl().setExpirationTime(1);
        String viewName = this.viewResolver.getFullStoryView((PortletRequest)request);
        return new ModelAndView(viewName, model.asMap());
    }

    @Autowired(required=true)
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Autowired(required=true)
    public void setSetCreationService(NewsSetResolvingService setCreationService) {
        this.setCreationService = setCreationService;
    }
}

