/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsDefinition;
import org.jasig.portlet.newsreader.PredefinedNewsConfiguration;
import org.jasig.portlet.newsreader.PredefinedNewsDefinition;
import org.jasig.portlet.newsreader.service.Whitelist;
import org.springframework.web.bind.annotation.ModelAttribute;

public class AbstractNewsController {
    public static final String INITIALIZED = "initialized";
    public static final String NEWS_ADMIN_ROLE = "newsAdmin";
    public static final String ALLOW_EDIT_PREFERENCE = "allowEdit";
    private static final Whitelist<PredefinedNewsConfiguration> WHITELIST = new Whitelist();
    public static final Whitelist.Callback<PredefinedNewsConfiguration> WHITELIST_CALLBACK = new Whitelist.Callback<PredefinedNewsConfiguration>(){

        @Override
        public String getFname(PredefinedNewsConfiguration item) {
            NewsDefinition def = item.getNewsDefinition();
            if (def instanceof PredefinedNewsDefinition) {
                PredefinedNewsDefinition predef = (PredefinedNewsDefinition)def;
                return predef.getFname();
            }
            String msg = "PredefinedNewsConfiguration based on non-predefined NewsDefinition:  " + item;
            throw new RuntimeException(msg);
        }
    };

    public static List<NewsConfiguration> filterNonWhitelistedPredefinedConfigurations(PortletRequest req, Collection<NewsConfiguration> items) {
        ArrayList<NewsConfiguration> rslt = new ArrayList<NewsConfiguration>();
        for (NewsConfiguration config : items) {
            PredefinedNewsConfiguration predef;
            List<PredefinedNewsConfiguration> filtered;
            if (config.getNewsDefinition().isPredefined() && (filtered = WHITELIST.filter(req, Collections.singleton(predef = (PredefinedNewsConfiguration)config), WHITELIST_CALLBACK)).size() == 0) continue;
            rslt.add(config);
        }
        return rslt;
    }

    @ModelAttribute(value="isAdmin")
    public boolean isAdmin(PortletRequest req) {
        return req.isUserInRole(NEWS_ADMIN_ROLE);
    }

    @ModelAttribute(value="isGuest")
    public boolean isGuest(PortletRequest req) {
        return req.getRemoteUser() == null;
    }

    @ModelAttribute(value="supportsEdit")
    public boolean supportsEdit(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String allowEdit = prefs.getValue(ALLOW_EDIT_PREFERENCE, "true");
        return Boolean.parseBoolean(allowEdit);
    }

    @ModelAttribute(value="supportsHelp")
    public boolean supportsHelp(PortletRequest req) {
        return req.isPortletModeAllowed(PortletMode.HELP);
    }
}

