/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.adapter.INewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.model.FullStory;
import org.jasig.portlet.newsreader.model.NewsFeed;
import org.jasig.portlet.newsreader.model.NewsFeedItem;
import org.jasig.portlet.newsreader.mvc.AbstractNewsController;
import org.jasig.portlet.newsreader.service.IInitializationService;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class NewsController
extends AbstractNewsController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private NewsStore newsStore;
    private int defaultItems = 2;
    private List<IInitializationService> initializationServices;
    private ApplicationContext applicationContext;
    private NewsSetResolvingService setCreationService;

    @Autowired
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    public void setDefaultItems(int defaultItems) {
        this.defaultItems = defaultItems;
    }

    @Resource(name="initializationServices")
    public void setInitializationServices(List<IInitializationService> services) {
        this.initializationServices = services;
    }

    @ActionMapping
    public void defaultAction() {
    }

    @ModelAttribute
    public void getPreferences(RenderRequest request, Model model) {
        PortletPreferences prefs = request.getPreferences();
        model.addAttribute("storyView", (Object)prefs.getValue("summaryView", "flyout"));
        model.addAttribute("feedView", (Object)prefs.getValue("feedView", "select"));
        model.addAttribute("newWindow", (Object)Boolean.valueOf(prefs.getValue("newWindow", "true")));
    }

    @RenderMapping
    public String showMainView(RenderRequest request) throws Exception {
        PortletSession session = request.getPortletSession(true);
        if (session.getAttribute("initialized") == null) {
            List<String> allRoles = this.newsStore.getUserRoles();
            this.log.debug((Object)("all roles: " + allRoles));
            HashSet<String> userRoles = new HashSet<String>();
            for (String role : allRoles) {
                if (!request.isUserInRole(role)) continue;
                userRoles.add(role);
            }
            session.setAttribute("userRoles", userRoles, 2);
            session.setAttribute("items", (Object)this.defaultItems);
            for (IInitializationService service : this.initializationServices) {
                service.initialize((PortletRequest)request);
            }
            session.setAttribute("initialized", (Object)true);
            session.setMaxInactiveInterval(7200);
        }
        PortletPreferences prefs = request.getPreferences();
        String viewName = prefs.getValue("viewName", "viewNews");
        return viewName;
    }

    @RenderMapping(params={"action=fullStory"})
    public ModelAndView fullStory(@RequestParam Long activeFeed, @RequestParam int itemIndex, @RequestParam int page, RenderRequest request, RenderResponse response, Model model) throws Exception {
        this.log.trace((Object)"fullStory (NewsController)");
        String setName = request.getPreferences().getValue("newsSetName", "default");
        NewsSet set = this.setCreationService.getNewsSet(setName, (PortletRequest)request);
        List<NewsConfiguration> feeds = AbstractNewsController.filterNonWhitelistedPredefinedConfigurations((PortletRequest)request, set.getNewsConfigurations());
        feeds.addAll(set.getNewsConfigurations());
        Collections.sort(feeds);
        JSONArray jsonFeeds = new JSONArray();
        ArrayList<String> knownFeeds = new ArrayList<String>();
        for (NewsConfiguration feed : feeds) {
            if (!feed.isDisplayed()) continue;
            JSONObject jsonFeed = new JSONObject();
            jsonFeed.put((Object)"id", (Object)feed.getId());
            jsonFeed.put((Object)"name", (Object)feed.getNewsDefinition().getName());
            jsonFeeds.add((Object)jsonFeed);
            knownFeeds.add(String.valueOf(feed.getId()));
        }
        this.log.debug((Object)("Known feeds: " + ((Object)knownFeeds).toString()));
        model.addAttribute("feeds", (Object)jsonFeeds);
        if (!knownFeeds.contains(activeFeed.toString())) {
            activeFeed = null;
            model.addAttribute("message", (Object)"Not allowed.");
            this.log.debug((Object)"Not allowd.");
        }
        model.addAttribute("activeFeed", (Object)activeFeed);
        NewsConfiguration feedConfig = this.newsStore.getNewsConfiguration(activeFeed);
        this.log.debug((Object)("On render Active feed is " + feedConfig.getId()));
        try {
            INewsAdapter adapter = (INewsAdapter)this.applicationContext.getBean(feedConfig.getNewsDefinition().getClassName());
            NewsFeed sharedFeed = adapter.getSyndFeed(feedConfig, page);
            if (sharedFeed != null) {
                NewsFeedItem item = sharedFeed.getEntries().get(itemIndex);
                model.addAttribute("storyTitle", (Object)item.getTitle());
                FullStory fullStory = item.getFullStory();
                model.addAttribute("fullStory", (Object)fullStory.getFullStoryText());
            } else {
                this.log.warn((Object)"Failed to get feed from adapter.");
                model.addAttribute("message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
            }
            PortletPreferences prefs = request.getPreferences();
            model.addAttribute("feedView", (Object)prefs.getValue("feedView", "select"));
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.log.error((Object)("News class instance could not be found: " + ex.getMessage()));
            model.addAttribute("message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
        }
        catch (NewsException ex) {
            this.log.warn((Object)ex);
            model.addAttribute("message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
            model.addAttribute("message", (Object)("The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable."));
        }
        String etag = String.valueOf(model.hashCode());
        String requestEtag = request.getETag();
        if (request.getETag() != null && etag.equals(requestEtag)) {
            response.getCacheControl().setExpirationTime(1);
            response.getCacheControl().setUseCachedContent(true);
            return new ModelAndView("empty", Collections.emptyMap());
        }
        response.getCacheControl().setETag(etag);
        response.getCacheControl().setExpirationTime(1);
        return new ModelAndView("fullStory", model.asMap());
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Autowired
    public void setSetCreationService(NewsSetResolvingService setCreationService) {
        this.setCreationService = setCreationService;
    }
}

