/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc;

import java.util.Collection;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.service.NewsConfigurationWhitelist;
import org.springframework.web.bind.annotation.ModelAttribute;

public class AbstractNewsController {
    public static final String INITIALIZED = "initialized";
    public static final String NEWS_ADMIN_ROLE = "newsAdmin";
    public static final String ALLOW_EDIT_PREFERENCE = "allowEdit";
    public static final String ALLOW_HELP_PREFERENCE = "allowHelp";
    private static final NewsConfigurationWhitelist WHITELIST = new NewsConfigurationWhitelist();

    public static List<NewsConfiguration> filterNonWhitelistedConfigurations(PortletRequest req, Collection<NewsConfiguration> items) {
        List<NewsConfiguration> filtered = WHITELIST.filter(req, items);
        return filtered;
    }

    @ModelAttribute(value="isAdmin")
    public boolean isAdmin(PortletRequest req) {
        return req.isUserInRole(NEWS_ADMIN_ROLE);
    }

    @ModelAttribute(value="isGuest")
    public boolean isGuest(PortletRequest req) {
        return req.getRemoteUser() == null;
    }

    @ModelAttribute(value="supportsEdit")
    public boolean supportsEdit(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String allowEdit = prefs.getValue(ALLOW_EDIT_PREFERENCE, "true");
        return Boolean.parseBoolean(allowEdit);
    }

    @ModelAttribute(value="supportsHelp")
    public boolean supportsHelp(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String allowHelp = prefs.getValue(ALLOW_HELP_PREFERENCE, "true");
        return Boolean.parseBoolean(allowHelp);
    }
}

