/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.model;

import java.util.Collections;
import java.util.List;
import org.jasig.portlet.newsreader.model.NewsFeed;
import org.jasig.portlet.newsreader.model.NewsFeedItem;
import org.springframework.beans.support.PagedListHolder;

public class PaginatingNewsFeed
extends NewsFeed {
    private static final long serialVersionUID = 1L;
    private final PagedListHolder<NewsFeedItem> holder = new PagedListHolder();

    public PaginatingNewsFeed(int entriesPerPage) {
        this.holder.setPage(0);
        this.holder.setPageSize(entriesPerPage);
        this.holder.setSource(super.getEntries());
    }

    public PaginatingNewsFeed(int entriesPerPage, int initialPage) {
        this.holder.setPage(initialPage);
        this.holder.setPageSize(entriesPerPage);
        this.holder.setSource(super.getEntries());
    }

    public int getPage() {
        return this.holder.getPage();
    }

    public void setPage(int p) {
        this.holder.setPage(p);
    }

    public double getPageCount() {
        return this.holder.getPageCount();
    }

    public List<NewsFeedItem> getEntries() {
        if (this.holder.getPage() < this.holder.getPageCount()) {
            return this.holder.getPageList();
        }
        return Collections.emptyList();
    }
}

