/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.newsreader.service.Whitelist;

public class Whitelist<T> {
    private static final String WHITELIST_REGEX_PREFERENCE = "Whitelist.regexValues";

    public List<T> filter(PortletRequest req, Collection<T> items, Callback<T> callback) {
        PortletPreferences prefs = req.getPreferences();
        String[] whitelistRegexValues = prefs.getValues(WHITELIST_REGEX_PREFERENCE, new String[0]);
        ArrayList<Object> rslt = new ArrayList<Object>();
        if (whitelistRegexValues.length > 0) {
            HashSet<Pattern> patterns = new HashSet<Pattern>();
            for (String regex : whitelistRegexValues) {
                patterns.add(Pattern.compile(regex));
            }
            block1: for (Object item : items) {
                String fname = callback.getFname(item);
                for (Pattern p : patterns) {
                    Matcher m = p.matcher(fname);
                    if (!m.matches()) continue;
                    rslt.add(item);
                    continue block1;
                }
            }
        } else {
            rslt.addAll(items);
        }
        return rslt;
    }
}

