/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.service;

import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;

public class SharedNewsSetServiceImpl
implements NewsSetResolvingService {
    private static Log log = LogFactory.getLog(SharedNewsSetServiceImpl.class);
    private NewsStore newsStore;

    @Override
    public NewsSet getNewsSet(String fname, PortletRequest request) {
        NewsSet set;
        PortletSession session = request.getPortletSession();
        String userId = request.getRemoteUser();
        if (userId == null) {
            userId = "guest";
        }
        if ((set = this.newsStore.getNewsSet(userId, fname)) == null) {
            log.debug((Object)"No existing set found, creating and saving new set.");
            set = new NewsSet();
            set.setUserId(userId);
            set.setName(fname);
            this.newsStore.storeNewsSet(set);
        }
        if (session.getAttribute("setId") == null) {
            log.debug((Object)("re-initalising loaded newsSet " + set.getName()));
            Set roles = (Set)session.getAttribute("userRoles", 2);
            this.newsStore.initNews(set, roles);
            this.newsStore.storeNewsSet(set);
            session.setAttribute("setId", (Object)set.getId(), 2);
        }
        return set;
    }

    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }
}

