/**
 * Licensed to Apereo under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Apereo licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License.  You may obtain a
 * copy of the License at the following location:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.portlet.newsreader;

import java.util.HashSet;
import java.util.Set;

public class NewsSet {

	private Long id = new Long(-1);
	private String name;
	private Set<NewsConfiguration> newsConfigurations = new HashSet<NewsConfiguration>();
	private String userId;
	
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Set<NewsConfiguration> getNewsConfigurations() {
		return newsConfigurations;
	}
	public void setNewsConfigurations(Set<NewsConfiguration> calendars) {
		this.newsConfigurations = calendars;
	}
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}
	
	public void addNewsConfiguration(NewsConfiguration config) {
		config.setNewsSet(this);
		this.newsConfigurations.add(config);
	}
	
	
}
