/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.service;

import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.portlet.util.PortletUtils;

public class SharedNewsSetServiceImpl
implements NewsSetResolvingService {
    private static Logger log = LoggerFactory.getLogger(SharedNewsSetServiceImpl.class);
    private NewsStore newsStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NewsSet getNewsSet(String fname, PortletRequest request) {
        NewsSet set;
        Object mutex;
        PortletSession session = request.getPortletSession();
        String userId = request.getRemoteUser();
        if (userId == null) {
            userId = "guest";
        }
        Object object = mutex = PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object) {
            log.debug("Got Mutex: " + mutex);
            set = this.newsStore.getNewsSet(userId, fname);
            if (set == null) {
                log.debug("No existing set found for " + userId + ", creating and saving new set.");
                set = new NewsSet();
                set.setUserId(userId);
                set.setName(fname);
                this.newsStore.storeNewsSet(set);
            }
            if (session.getAttribute("setId", 2) == null) {
                log.debug("re-initalising loaded newsSet " + set.getName());
                Set roles = (Set)session.getAttribute("userRoles", 2);
                if (roles != null) {
                    this.newsStore.initNews(set, roles);
                    this.newsStore.storeNewsSet(set);
                    session.setAttribute("setId", (Object)set.getId(), 2);
                }
            }
        }
        return set;
    }

    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }
}

