/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import java.util.List;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.jasig.portlet.newsreader.NewsDefinition;
import org.jasig.portlet.newsreader.PredefinedNewsDefinition;
import org.jasig.portlet.newsreader.adapter.INewsAdapter;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.mvc.NewsDefinitionForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class EditNewsDefinitionController {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private NewsStore newsStore;
    @Resource(name="availableAdapters")
    private List<INewsAdapter> availableAdapters;

    @Autowired(required=true)
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    @ModelAttribute(value="newsDefinitionForm")
    public NewsDefinitionForm getNewsForm(PortletRequest request) throws Exception {
        String id = request.getParameter("id");
        if (id != null && !id.equals("")) {
            Long definitionId = Long.parseLong(id);
            if (definitionId > -1L) {
                PredefinedNewsDefinition definition = this.newsStore.getPredefinedNewsDefinition(definitionId);
                NewsDefinitionForm command = new NewsDefinitionForm();
                command.setId(definition.getId());
                command.setName(definition.getName());
                command.setClassName(definition.getClassName());
                command.setRole(definition.getDefaultRoles());
                command.addParameters(definition.getParameters());
                return command;
            }
            return new NewsDefinitionForm();
        }
        return new NewsDefinitionForm();
    }

    @RenderMapping(params={"action=editNewsDefinition"})
    public String getAdminNewsEditView() {
        return "editNewsDefinition";
    }

    @ActionMapping(params={"action=editNewsDefinition"})
    public void onSubmitAction(ActionRequest request, ActionResponse response, NewsDefinitionForm form) throws Exception {
        PredefinedNewsDefinition definition = null;
        definition = form.getId() > -1L ? this.newsStore.getPredefinedNewsDefinition(form.getId()) : new PredefinedNewsDefinition();
        definition.setClassName(form.getClassName());
        definition.setDefaultRoles(form.getRole());
        definition.setName(form.getName());
        definition.setParameters(form.getParameters());
        this.newsStore.storeNewsDefinition((NewsDefinition)definition);
        response.setRenderParameter("action", "administration");
    }

    @ModelAttribute(value="availableAdapters")
    public List<INewsAdapter> getAvailableAdapters() {
        return this.availableAdapters;
    }
}

